package cn.ctyun.apis.proxysql;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询RDS实例独享代理的连接地址信息 */
public class Rds2QueryProxyEndpointApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2QueryProxyEndpointApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/proxy/endpoint", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryProxyEndpointResponse send(Credential credential, QueryProxyEndpointRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryProxyEndpointResponse.class);
    }

    public static class QueryProxyEndpointRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class QueryProxyEndpointResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryProxyEndpointReturnObjResponse returnObj;

        /** 返回信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public QueryProxyEndpointReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryProxyEndpointReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryProxyEndpointReturnObjResponse {
        /** 代理数量 */
        @JsonProperty("instanceCount")
        private Integer instanceCount;

        /** 代理实例信息 */
        @JsonProperty("proxyInstanceVoList")
        private List<QueryProxyEndpointReturnObjProxyInstanceVoListResponse> proxyInstanceVoList;

        public Integer getInstanceCount() {
            return this.instanceCount;
        }

        public void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public List<QueryProxyEndpointReturnObjProxyInstanceVoListResponse>
        getProxyInstanceVoList() {
            return this.proxyInstanceVoList;
        }

        public void setProxyInstanceVoList(
                List<QueryProxyEndpointReturnObjProxyInstanceVoListResponse> proxyInstanceVoList) {
            this.proxyInstanceVoList = proxyInstanceVoList;
        }
    }

    public static class QueryProxyEndpointReturnObjProxyInstanceVoListResponse {
        /** 虚拟IP地址 */
        @JsonProperty("vip")
        private String vip;

        /** 服务端口 */
        @JsonProperty("servicePort")
        private String servicePort;

        /** 虚拟IP地址 */
        @JsonProperty("eip")
        private String eip;

        /** 实例id */
        @JsonProperty("outerProxyInstId")
        private String outerProxyInstId;

        /** vpc网络名称 */
        @JsonProperty("netName")
        private String netName;

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public String getServicePort() {
            return this.servicePort;
        }

        public void setServicePort(String servicePort) {
            this.servicePort = servicePort;
        }

        public String getEip() {
            return this.eip;
        }

        public void setEip(String eip) {
            this.eip = eip;
        }

        public String getOuterProxyInstId() {
            return this.outerProxyInstId;
        }

        public void setOuterProxyInstId(String outerProxyInstId) {
            this.outerProxyInstId = outerProxyInstId;
        }

        public String getNetName() {
            return this.netName;
        }

        public void setNetName(String netName) {
            this.netName = netName;
        }
    }
}
