package cn.ctyun.apis.proxysql;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询独享代理SSL信息 */
public class Rds2GetProxySslDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetProxySslDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/proxy/proxy-ssl-detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetProxySslDetailResponse send(Credential credential, GetProxySslDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProxyInstId != null) {
            ctReq.addParam("outerProxyInstId", request.outerProxyInstId);
            request.outerProxyInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetProxySslDetailResponse.class);
    }

    public static class GetProxySslDetailRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 代理id */
        @JsonProperty("outerProxyInstId")
        private String outerProxyInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProxyInstId() {
            return this.outerProxyInstId;
        }

        public void setOuterProxyInstId(String outerProxyInstId) {
            this.outerProxyInstId = outerProxyInstId;
        }
    }

    public static class GetProxySslDetailResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetProxySslDetailReturnObjResponse returnObj;

        /** 返回信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public GetProxySslDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetProxySslDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetProxySslDetailReturnObjResponse {
        /** 独享代理实例id */
        @JsonProperty("outerProxyInstId")
        private String outerProxyInstId;

        /** 开关状态，true: 开启，false：关闭 */
        @JsonProperty("enableSsl")
        private Boolean enableSsl;

        /** 当前 CA 证书序列号，仅开启时有数据返回 */
        @JsonProperty("sslSerialNumber")
        private String sslSerialNumber;

        /** 当前 CA 证书过期时间，仅开启时有数据返回 */
        @JsonProperty("sslExpiredTime")
        private String sslExpiredTime;

        public String getOuterProxyInstId() {
            return this.outerProxyInstId;
        }

        public void setOuterProxyInstId(String outerProxyInstId) {
            this.outerProxyInstId = outerProxyInstId;
        }

        public Boolean getEnableSsl() {
            return this.enableSsl;
        }

        public void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public String getSslSerialNumber() {
            return this.sslSerialNumber;
        }

        public void setSslSerialNumber(String sslSerialNumber) {
            this.sslSerialNumber = sslSerialNumber;
        }

        public String getSslExpiredTime() {
            return this.sslExpiredTime;
        }

        public void setSslExpiredTime(String sslExpiredTime) {
            this.sslExpiredTime = sslExpiredTime;
        }
    }
}

