package cn.ctyun.apis.proxysql;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询独享代理的性能数据 */
public class Rds2GetProxyHealthInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetProxyHealthInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/proxy/health-info", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetProxyHealthInfoResponse send(Credential credential, GetProxyHealthInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProxyInstId != null) {
            ctReq.addParam("outerProxyInstId", request.outerProxyInstId);
            request.outerProxyInstId = null;
        }
        if (request.beginTime != null) {
            ctReq.addParam("beginTime", request.beginTime);
            request.beginTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetProxyHealthInfoResponse.class);
    }

    public static class GetProxyHealthInfoRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 代理id */
        @JsonProperty("outerProxyInstId")
        private String outerProxyInstId;

        /** 开始时间 yyyy-MM-dd HH:mm:ss */
        @JsonProperty("beginTime")
        private String beginTime;

        /** 结束时间 yyyy-MM-dd HH:mm:ss */
        @JsonProperty("endTime")
        private String endTime;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProxyInstId() {
            return this.outerProxyInstId;
        }

        public void setOuterProxyInstId(String outerProxyInstId) {
            this.outerProxyInstId = outerProxyInstId;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }
    }

    public static class GetProxyHealthInfoResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetProxyHealthInfoReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetProxyHealthInfoReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetProxyHealthInfoReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetProxyHealthInfoReturnObjResponse {
        /** 节点角色, m:主节点，s:从节点 */
        @JsonProperty("role")
        private String role;

        /** 节点资源ID */
        @JsonProperty("resId")
        private Integer resId;

        /** 时间线 */
        @JsonProperty("time")
        private List<String> time;

        /** Cpu 系统使用率 */
        @JsonProperty("sys")
        private List<Integer> sys;

        /** Cpu 用户使用率 */
        @JsonProperty("usr")
        private List<Integer> usr;

        /** 软中断 Cpu 使用率 */
        @JsonProperty("si")
        private List<Integer> si;

        /** 服务端当前失败连接数 */
        @JsonProperty("srvFailConnect")
        private List<Integer> srvFailConnect;

        /** 服务端当前连接数 */
        @JsonProperty("srvCurConnect")
        private List<Integer> srvCurConnect;

        /** 服务端当前新建连接数 */
        @JsonProperty("srvIncConnect")
        private List<Integer> srvIncConnect;

        /** 客户端当前失败连接数 */
        @JsonProperty("cliFailConnect")
        private List<Integer> cliFailConnect;

        /** 客户端当前连接数 */
        @JsonProperty("cliCurConnect")
        private List<Integer> cliCurConnect;

        /** 客户端当前新建连接数 */
        @JsonProperty("cliIncConnect")
        private List<Integer> cliIncConnect;

        /** 总CPU使用率 */
        @JsonProperty("cpuUsedRate")
        private List<String> cpuUsedRate;

        /** 总内存使用率 */
        @JsonProperty("memoryUsedRate")
        private List<String> memoryUsedRate;

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public List<String> getTime() {
            return this.time;
        }

        public void setTime(List<String> time) {
            this.time = time;
        }

        public List<Integer> getSys() {
            return this.sys;
        }

        public void setSys(List<Integer> sys) {
            this.sys = sys;
        }

        public List<Integer> getUsr() {
            return this.usr;
        }

        public void setUsr(List<Integer> usr) {
            this.usr = usr;
        }

        public List<Integer> getSi() {
            return this.si;
        }

        public void setSi(List<Integer> si) {
            this.si = si;
        }

        public List<Integer> getSrvFailConnect() {
            return this.srvFailConnect;
        }

        public void setSrvFailConnect(List<Integer> srvFailConnect) {
            this.srvFailConnect = srvFailConnect;
        }

        public List<Integer> getSrvCurConnect() {
            return this.srvCurConnect;
        }

        public void setSrvCurConnect(List<Integer> srvCurConnect) {
            this.srvCurConnect = srvCurConnect;
        }

        public List<Integer> getSrvIncConnect() {
            return this.srvIncConnect;
        }

        public void setSrvIncConnect(List<Integer> srvIncConnect) {
            this.srvIncConnect = srvIncConnect;
        }

        public List<Integer> getCliFailConnect() {
            return this.cliFailConnect;
        }

        public void setCliFailConnect(List<Integer> cliFailConnect) {
            this.cliFailConnect = cliFailConnect;
        }

        public List<Integer> getCliCurConnect() {
            return this.cliCurConnect;
        }

        public void setCliCurConnect(List<Integer> cliCurConnect) {
            this.cliCurConnect = cliCurConnect;
        }

        public List<Integer> getCliIncConnect() {
            return this.cliIncConnect;
        }

        public void setCliIncConnect(List<Integer> cliIncConnect) {
            this.cliIncConnect = cliIncConnect;
        }

        public List<String> getCpuUsedRate() {
            return this.cpuUsedRate;
        }

        public void setCpuUsedRate(List<String> cpuUsedRate) {
            this.cpuUsedRate = cpuUsedRate;
        }

        public List<String> getMemoryUsedRate() {
            return this.memoryUsedRate;
        }

        public void setMemoryUsedRate(List<String> memoryUsedRate) {
            this.memoryUsedRate = memoryUsedRate;
        }
    }
}

