package cn.ctyun.apis.proxysql;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 修改数据库独享代理的代理终端 */
public class Rds2ConfigProxyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ConfigProxyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/proxy/config",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ConfigProxyResponse send(Credential credential, ConfigProxyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ConfigProxyResponse.class);
    }

    public static class ConfigProxyRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 代理id */
        @JsonProperty("outerProxyInstId")
        private String outerProxyInstId;

        /** -1: 表示从未配置过(不可设置-1); 0： 读写分离加密方式 */
        @JsonProperty("featureAttribute")
        private Integer featureAttribute;

        /** 事务拆分: 0：功能未开通 1：功能已开通 */
        @JsonProperty("transactionReadSqlRouteOptimizeStatus")
        private Integer transactionReadSqlRouteOptimizeStatus;

        /** 读权重分配模式: 自动分配(Standard), 自定义分配权重(Custom) */
        @JsonProperty("readOnlyInstanceDistributionType")
        private String readOnlyInstanceDistributionType;

        /** 连接池类型: 0：功能未开通(不可设置为0) 连接池类型: 1：事务级连接池 2：会话级连接池 */
        @JsonProperty("connectionPersist")
        private Integer connectionPersist;

        /** 读写分离中只读实例的最大延迟阈值 */
        @JsonProperty("readOnlyInstanceMaxDelayTime")
        private Integer readOnlyInstanceMaxDelayTime;

        /** 后端数据库服务节点的只读权重配置列表 */
        @JsonProperty("readOnlyInstanceWeight")
        private List<ConfigProxyReadOnlyInstanceWeightRequest> readOnlyInstanceWeight;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProxyInstId() {
            return this.outerProxyInstId;
        }

        public void setOuterProxyInstId(String outerProxyInstId) {
            this.outerProxyInstId = outerProxyInstId;
        }

        public Integer getFeatureAttribute() {
            return this.featureAttribute;
        }

        public void setFeatureAttribute(Integer featureAttribute) {
            this.featureAttribute = featureAttribute;
        }

        public Integer getTransactionReadSqlRouteOptimizeStatus() {
            return this.transactionReadSqlRouteOptimizeStatus;
        }

        public void setTransactionReadSqlRouteOptimizeStatus(
                Integer transactionReadSqlRouteOptimizeStatus) {
            this.transactionReadSqlRouteOptimizeStatus = transactionReadSqlRouteOptimizeStatus;
        }

        public String getReadOnlyInstanceDistributionType() {
            return this.readOnlyInstanceDistributionType;
        }

        public void setReadOnlyInstanceDistributionType(String readOnlyInstanceDistributionType) {
            this.readOnlyInstanceDistributionType = readOnlyInstanceDistributionType;
        }

        public Integer getConnectionPersist() {
            return this.connectionPersist;
        }

        public void setConnectionPersist(Integer connectionPersist) {
            this.connectionPersist = connectionPersist;
        }

        public Integer getReadOnlyInstanceMaxDelayTime() {
            return this.readOnlyInstanceMaxDelayTime;
        }

        public void setReadOnlyInstanceMaxDelayTime(Integer readOnlyInstanceMaxDelayTime) {
            this.readOnlyInstanceMaxDelayTime = readOnlyInstanceMaxDelayTime;
        }

        public List<ConfigProxyReadOnlyInstanceWeightRequest> getReadOnlyInstanceWeight() {
            return this.readOnlyInstanceWeight;
        }

        public void setReadOnlyInstanceWeight(
                List<ConfigProxyReadOnlyInstanceWeightRequest> readOnlyInstanceWeight) {
            this.readOnlyInstanceWeight = readOnlyInstanceWeight;
        }
    }

    public static class ConfigProxyReadOnlyInstanceWeightRequest {
        /** 节点对应的只读权重 */
        @JsonProperty("weight")
        private String weight;

        /** 数据库实例的节点ID */
        @JsonProperty("resId")
        private Integer resId;

        /** eddf4d2c6d67407ba39e3453ee0776ca */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getWeight() {
            return this.weight;
        }

        public void setWeight(String weight) {
            this.weight = weight;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class ConfigProxyResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
