package cn.ctyun.apis.parameter;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.HashMap;
import java.util.Map;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 修改RDS参数 */
public class Rds2ModifyRdsParameterV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ModifyRdsParameterV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/RDS2/v1/open-api/parameter/rds-parameter",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifyRdsParameterV4Response send(
            Credential credential, ModifyRdsParameterV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyRdsParameterV4Response.class);
    }

    public static class ModifyRdsParameterV4Request {
        /**
         * 项目id
         */
        @JsonProperty("project-id")
        private String projectId;

        /**
         * 实例id （和参数outerProdInstId保持一致）
         */
        @JsonProperty("inst-id")
        private String instId;

        /**
         * 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /**
         * 参数模版id(请确保id所指向的参数模板的适用MySQL版本与实例MySQL版本保持一致。)。传入该参数，则无需传入parameters
         */
        @JsonProperty("id")
        private Integer id;

        /**
         * 要修改的参数对。传入该参数，则无需传入id
         */
        @JsonProperty("parameters")
        private Map<String, String> parameters;


        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        // 添加一个便捷方法，用于设置单个参数
        public void setParameter(String key, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap<>();
            }
            this.parameters.put(key, value);
        }
    }
    public static class ModifyRdsParameterV4Response {
        /** 返回码取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private ModifyRdsParameterV4ReturnObjResponse returnObj;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public ModifyRdsParameterV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifyRdsParameterV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ModifyRdsParameterV4ReturnObjResponse {}
}
