package cn.ctyun.apis.parameter;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 根据参数模板id修改参数模板值 */
public class Rds2ModifyParameterV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ModifyParameterV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/RDS2/v1/open-api/parameter/modify-parameter",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifyParameterV4Response send(Credential credential, ModifyParameterV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyParameterV4Response.class);
    }

    public static class ModifyParameterV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 模板参数ID */
        @JsonProperty("id")
        private String id;

        /** 数据库引擎 */
        @JsonProperty("value")
        private List<ModifyParameterV4ValueRequest> value;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<ModifyParameterV4ValueRequest> getValue() {
            return this.value;
        }

        public void setValue(List<ModifyParameterV4ValueRequest> value) {
            this.value = value;
        }
    }

    public static class ModifyParameterV4ValueRequest {
        /** 旧参数值 */
        @JsonProperty("oldValue")
        private String oldValue;

        /** 修改参数名 */
        @JsonProperty("parameterName")
        private String parameterName;

        /** 修改参数值 */
        @JsonProperty("parameterValue")
        private String parameterValue;

        /** 是否重启 */
        @JsonProperty("restart")
        private String restart;

        public String getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getParameterValue() {
            return this.parameterValue;
        }

        public void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public String getRestart() {
            return this.restart;
        }

        public void setRestart(String restart) {
            this.restart = restart;
        }
    }

    public static class ModifyParameterV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回信息 */
        @JsonProperty("returnObj")
        private ModifyParameterV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ModifyParameterV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifyParameterV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ModifyParameterV4ReturnObjResponse {}
}
