package cn.ctyun.apis.parameter;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 获取参数模板详细信息 */
public class Rds2FindAllParameterDetailsV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2FindAllParameterDetailsV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/parameter/parameter-templates",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public FindAllParameterDetailsV4Response send(
            Credential credential, FindAllParameterDetailsV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.id != null) {
            ctReq.addParam("id", String.valueOf(request.id));
            request.id = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(FindAllParameterDetailsV4Response.class);
    }

    public static class FindAllParameterDetailsV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 模版ID */
        @JsonProperty("id")
        private Integer id;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    public static class FindAllParameterDetailsV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private FindAllParameterDetailsV4ReturnObjResponse returnObj;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public FindAllParameterDetailsV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(FindAllParameterDetailsV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

    }

    public static class FindAllParameterDetailsV4ReturnObjResponse {
        /** 终行 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 是否有后一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 最后一页 */
        @JsonProperty("lastPage")
        private Integer lastPage;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 页数 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 页 */
        @JsonProperty("pages")
        private Integer pages;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 大小 */
        @JsonProperty("size")
        private Integer size;

        /** 开始行 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        @JsonProperty("navigatepageNums")
        private List<Integer> navigatepageNums;



        @JsonProperty("navigatePages")
        private Integer navigatePages;

        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 对象数组 */
        @JsonProperty("list")
        private List<FindAllParameterDetailsV4ReturnObjListResponse> list;

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Integer getLastPage() {
            return this.lastPage;
        }

        public void setLastPage(Integer lastPage) {
            this.lastPage = lastPage;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<FindAllParameterDetailsV4ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<FindAllParameterDetailsV4ReturnObjListResponse> list) {
            this.list = list;
        }



        public List<Integer> getNavigatepageNums() {
            return navigatepageNums;
        }

        public void setNavigatepageNums(List<Integer> navigatepageNums) {
            this.navigatepageNums = navigatepageNums;
        }

        public Integer getNavigatePages() {
            return navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNavigateFirstPage() {
            return navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public Integer getNavigateLastPage() {
            return navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

    }

    public static class FindAllParameterDetailsV4ReturnObjListResponse {
        /** 类型 */
        @JsonProperty("valuetype")
        private String valuetype;

        /** 是否需要重启 */
        @JsonProperty("restart")
        private String restart;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 编号 */
        @JsonProperty("id")
        private Integer id;

        /** 用户id */
        @JsonProperty("userId")
        private Integer userId;

        @JsonProperty("parameterGroupName")
        private String parameterGroupName;
        @JsonProperty("oldValue")
        private String oldValue;

        @JsonProperty("parameterName")
        private String parameterName;
        @JsonProperty("parameterValue")
        private String parameterValue;
        @JsonProperty("permitValue")
        private String permitValue;
        @JsonProperty("descriptionEn")
        private String descriptionEn;



        public String getParameterGroupName() {
            return parameterGroupName;
        }

        public void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public String getOldValue() {
            return oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getParameterName() {
            return parameterName;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getParameterValue() {
            return parameterValue;
        }

        public void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public String getPermitValue() {
            return permitValue;
        }

        public void setPermitValue(String permitValue) {
            this.permitValue = permitValue;
        }

        public String getDescriptionEn() {
            return descriptionEn;
        }

        public void setDescriptionEn(String descriptionEn) {
            this.descriptionEn = descriptionEn;
        }

        public String getValuetype() {
            return this.valuetype;
        }

        public void setValuetype(String valuetype) {
            this.valuetype = valuetype;
        }

        public String getRestart() {
            return this.restart;
        }

        public void setRestart(String restart) {
            this.restart = restart;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }


    }
}
