package cn.ctyun.apis.parameter;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询实例当前参数配置 */
public class Rds2DescribeParametersV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2DescribeParametersV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/parameter/describe-parameters",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeParametersV4Response send(
            Credential credential, DescribeParametersV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeParametersV4Response.class);
    }

    public static class DescribeParametersV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例Id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public String toString() {
            return "DescribeParametersV4Request{" +
                    "projectId='" + projectId + '\'' +
                    ", instId='" + instId + '\'' +
                    ", regionId='" + regionId + '\'' +
                    ", outerProdInstId='" + outerProdInstId + '\'' +
                    ", pageNow=" + pageNow +
                    ", pageSize=" + pageSize +
                    '}';
        }
    }

    public static class DescribeParametersV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DescribeParametersV4ReturnObjResponse returnObj;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public DescribeParametersV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeParametersV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "{" +
                    "statusCode=" + statusCode +
                    ", message='" + message + '\'' +
                    ", returnObj=" + returnObj +
                    ", error='" + error + '\'' +
                    '}';
        }
    }

    public static class DescribeParametersV4ReturnObjResponse {
        /** 导航页码数组 */
        @JsonProperty("navigatepageNums")
        private List<Integer> navigatepageNums;

        /** 开始行 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 是否有后一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 终行 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 参数列表 */
        @JsonProperty("list")
        private List<ParameterItem> list;

        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 导航第一页 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 大小 */
        @JsonProperty("size")
        private Integer size;

        /** 是否最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 导航最后一页 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 是否第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        public List<Integer> getNavigatepageNums() {
            return navigatepageNums;
        }

        public void setNavigatepageNums(List<Integer> navigatepageNums) {
            this.navigatepageNums = navigatepageNums;
        }

        public Integer getStartRow() {
            return startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Boolean getHasNextPage() {
            return hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getPrePage() {
            return prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Integer getNextPage() {
            return nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getEndRow() {
            return endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getPageSize() {
            return pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public List<ParameterItem> getList() {
            return list;
        }

        public void setList(List<ParameterItem> list) {
            this.list = list;
        }

        public Integer getPageNum() {
            return pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getNavigatePages() {
            return navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNavigateFirstPage() {
            return navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public Integer getTotal() {
            return total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getSize() {
            return size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Boolean getIsLastPage() {
            return isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Integer getNavigateLastPage() {
            return navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public Boolean getIsFirstPage() {
            return isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        @Override
        public String toString() {
            return "{" +
                    "navigatepageNums=" + navigatepageNums +
                    ", startRow=" + startRow +
                    ", hasNextPage=" + hasNextPage +
                    ", prePage=" + prePage +
                    ", nextPage=" + nextPage +
                    ", endRow=" + endRow +
                    ", pageSize=" + pageSize +
                    ", list=" + list +
                    ", pageNum=" + pageNum +
                    ", navigatePages=" + navigatePages +
                    ", navigateFirstPage=" + navigateFirstPage +
                    ", total=" + total +
                    ", pages=" + pages +
                    ", size=" + size +
                    ", isLastPage=" + isLastPage +
                    ", hasPreviousPage=" + hasPreviousPage +
                    ", navigateLastPage=" + navigateLastPage +
                    ", isFirstPage=" + isFirstPage +
                    '}';
        }
    }

    public static class ParameterItem {
        /** 参数组名称 */
        @JsonProperty("parameterGroupName")
        private String parameterGroupName;

        /** 值类型 */
        @JsonProperty("valuetype")
        private String valuetype;

        /** 英文描述 */
        @JsonProperty("descriptionEn")
        private String descriptionEn;

        /** 是否需要重启 */
        @JsonProperty("restart")
        private String restart;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 产品实例ID */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** ID */
        @JsonProperty("id")
        private Integer id;

        /** 参数名称 */
        @JsonProperty("parameterName")
        private String parameterName;

        /** 参数值 */
        @JsonProperty("parameterValue")
        private String parameterValue;

        /** 允许值 */
        @JsonProperty("permitValue")
        private String permitValue;

        /** 用户ID */
        @JsonProperty("userId")
        private Integer userId;

        public String getParameterGroupName() {
            return parameterGroupName;
        }

        public void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public String getValuetype() {
            return valuetype;
        }

        public void setValuetype(String valuetype) {
            this.valuetype = valuetype;
        }

        public String getDescriptionEn() {
            return descriptionEn;
        }

        public void setDescriptionEn(String descriptionEn) {
            this.descriptionEn = descriptionEn;
        }

        public String getRestart() {
            return restart;
        }

        public void setRestart(String restart) {
            this.restart = restart;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getProdInstId() {
            return prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getParameterName() {
            return parameterName;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getParameterValue() {
            return parameterValue;
        }

        public void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public String getPermitValue() {
            return permitValue;
        }

        public void setPermitValue(String permitValue) {
            this.permitValue = permitValue;
        }

        public Integer getUserId() {
            return userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        @Override
        public String toString() {
            return "{" +
                    "parameterGroupName='" + parameterGroupName + '\'' +
                    ", valuetype='" + valuetype + '\'' +
                    ", descriptionEn='" + descriptionEn + '\'' +
                    ", restart='" + restart + '\'' +
                    ", description='" + description + '\'' +
                    ", prodInstId=" + prodInstId +
                    ", id=" + id +
                    ", parameterName='" + parameterName + '\'' +
                    ", parameterValue='" + parameterValue + '\'' +
                    ", permitValue='" + permitValue + '\'' +
                    ", userId=" + userId +
                    '}';
        }
    }
}