package cn.ctyun.apis.parameter;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据模板id查询RDS参数模板的信息 */
public class Rds2DescParameterGroupV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2DescParameterGroupV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/parameter/describe-parameter-group",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescParameterGroupV4Response send(
            Credential credential, DescParameterGroupV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.id != null) {
            ctReq.addParam("id", String.valueOf(request.id));
            request.id = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescParameterGroupV4Response.class);
    }

    public static class DescParameterGroupV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 模板id */
        @JsonProperty("id")
        private Integer id;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    public static class DescParameterGroupV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DescParameterGroupV4ReturnObjResponse returnObj;

        /** 操作信息 */
        @JsonProperty("opMessage")
        private String opMessage;

        /** 结果信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public DescParameterGroupV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescParameterGroupV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getOpMessage() {
            return this.opMessage;
        }

        public void setOpMessage(String opMessage) {
            this.opMessage = opMessage;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescParameterGroupV4ReturnObjResponse {
        /** 参数模版id */
        @JsonProperty("id")
        private Integer id;

        /** 用户id */
        @JsonProperty("userId")
        private Integer userId;

        /** 参数组名称 */
        @JsonProperty("parameterGroupName")
        private String parameterGroupName;

        /** 引擎 */
        @JsonProperty("mysqlEngine")
        private String mysqlEngine;

        /** 创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 属否是默认参数组 */
        @JsonProperty("isdefault")
        private Integer isdefault;

        /** 修改该参数是否需要重启 */
        @JsonProperty("restart")
        private Boolean restart;

        /** 参数信息 */
        @JsonProperty("paramDetail")
        private List<DescParameterGroupV4ReturnObjParamDetailResponse> paramDetail;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public String getMysqlEngine() {
            return this.mysqlEngine;
        }

        public void setMysqlEngine(String mysqlEngine) {
            this.mysqlEngine = mysqlEngine;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getIsdefault() {
            return this.isdefault;
        }

        public void setIsdefault(Integer isdefault) {
            this.isdefault = isdefault;
        }

        public Boolean getRestart() {
            return this.restart;
        }

        public void setRestart(Boolean restart) {
            this.restart = restart;
        }

        public List<DescParameterGroupV4ReturnObjParamDetailResponse> getParamDetail() {
            return this.paramDetail;
        }

        public void setParamDetail(
                List<DescParameterGroupV4ReturnObjParamDetailResponse> paramDetail) {
            this.paramDetail = paramDetail;
        }
    }

    public static class DescParameterGroupV4ReturnObjParamDetailResponse {
        /** 参数名 */
        @JsonProperty("ParamName")
        private String paramName;

        /** 参数值 */
        @JsonProperty("ParamValue")
        private String paramValue;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getParamValue() {
            return this.paramValue;
        }

        public void setParamValue(String paramValue) {
            this.paramValue = paramValue;
        }
    }
}
