package cn.ctyun.apis.parameter;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 创建新的参数模板 */
public class Rds2CreateNewParameterGroupV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CreateNewParameterGroupV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/parameter/parameter-group",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateNewParameterGroupV4Response send(
            Credential credential, CreateNewParameterGroupV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateNewParameterGroupV4Response.class);
    }

    public static class CreateNewParameterGroupV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 模板参数名 */
        @JsonProperty("parameterGroupName")
        private String parameterGroupName;

        /** 数据库引擎 枚举 '5.7' '8.0' */
        @JsonProperty("engine")
        private String engine;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public String getEngine() {
            return this.engine;
        }

        public void setEngine(String engine) {
            this.engine = engine;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class CreateNewParameterGroupV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回信息 */
        @JsonProperty("returnObj")
        private CreateNewParameterGroupV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateNewParameterGroupV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateNewParameterGroupV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "{" +
                    "statusCode=" + statusCode +
                    ", message='" + message + '\'' +
                    ", returnObj=" + returnObj +
                    ", error='" + error + '\'' +
                    '}';
        }
    }

    public static class CreateNewParameterGroupV4ReturnObjResponse {
        @Override
        public String toString() {
            return "{}";
        }
    }
}
