package cn.ctyun.apis.notify;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口查询RDS通知列表 */
public class Rds2QueryNotifyV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2QueryNotifyV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/other/query-notify",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryNotifyV4Response send(Credential credential, QueryNotifyV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.withConfirmed != null) {
            ctReq.addParam("withConfirmed", String.valueOf(request.withConfirmed));
            request.withConfirmed = null;
        }
        if (request.from != null) {
            ctReq.addParam("from", request.from);
            request.from = null;
        }
        if (request.to != null) {
            ctReq.addParam("to", request.to);
            request.to = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", request.pageNow);
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", request.pageSize);
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryNotifyV4Response.class);
    }

    public static class QueryNotifyV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 是否包含已确认通知，默认为true */
        @JsonProperty("withConfirmed")
        private Boolean withConfirmed;

        /** 查询通知起始时间，格式为'yyyy-MM-ddCHH:mm:ss',其中C代表中国标准时间 */
        @JsonProperty("from")
        private String from;

        /** 查询通知截止时间,格式为'yyyy-MM-ddCHH:mm:ss',其中C代表中国标准时间 */
        @JsonProperty("to")
        private String to;

        /** 当前页码 */
        @JsonProperty("pageNow")
        private String pageNow;

        /** 每页包含通知条数 */
        @JsonProperty("pageSize")
        private String pageSize;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Boolean getWithConfirmed() {
            return this.withConfirmed;
        }

        public void setWithConfirmed(Boolean withConfirmed) {
            this.withConfirmed = withConfirmed;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(String pageNow) {
            this.pageNow = pageNow;
        }

        public String getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryNotifyV4Response {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果信息 */
        @JsonProperty("returnObj")
        private QueryNotifyV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public QueryNotifyV4ReturnObjResponse getReturnObj() {
            return returnObj;
        }

        public void setReturnObj(QueryNotifyV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryNotifyV4ReturnObjResponse {
        /** 起始页 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 可选页码范围 */
        @JsonProperty("navigatepageNums")
        private List<Integer> navigatepageNums;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 上一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 结束行数 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 每页数据行数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 页数 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页显示的页码个数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 总条数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 当前页条目数 */
        @JsonProperty("size")
        private Integer size;

        /** 是否是最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有上一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 是否是首页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 数据集合 */
        @JsonProperty("list")
        private List<QueryNotifyV4ReturnObjListResponse> list;

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public List<Integer> getNavigatepageNums() {
            return this.navigatepageNums;
        }

        public void setNavigatepageNums(List<Integer> navigatepageNums) {
            this.navigatepageNums = navigatepageNums;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public Boolean getFirstPage() {
            return isFirstPage;
        }

        public void setFirstPage(Boolean firstPage) {
            isFirstPage = firstPage;
        }

        public List<QueryNotifyV4ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<QueryNotifyV4ReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class QueryNotifyV4ReturnObjListResponse {
        /** 通知id */
        @JsonProperty("id")
        private String id;

        /** 通知所属租户id */
        @JsonProperty("userId")
        private Long userId;

        /** 通知类型 */
        @JsonProperty("type")
        private String type;

        /** 通知级别 */
        @JsonProperty("level")
        private String level;

        /** 通知标题 */
        @JsonProperty("title")
        private String title;

        /** 通知内容 */
        @JsonProperty("content")
        private String content;

        /** 通知是否被确认 */
        @JsonProperty("confirmFlag")
        private Boolean confirmFlag;

        /** 通知确认者id，0代表被系统确认 */
        @JsonProperty("confirmor")
        private Long confirmor;

        /** 通知创建时间,格式为'yyyy-MM-ddCHH:mm:ss',其中C代表中国标准时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** 通知确认时间,格式为'yyyy-MM-ddCHH:mm:ss',其中C代表中国标准时间 */
        @JsonProperty("updateTime")
        private String updateTime;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public Boolean getConfirmFlag() {
            return this.confirmFlag;
        }

        public void setConfirmFlag(Boolean confirmFlag) {
            this.confirmFlag = confirmFlag;
        }

        public Long getConfirmor() {
            return this.confirmor;
        }

        public void setConfirmor(Long confirmor) {
            this.confirmor = confirmor;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(String updateTime) {
            this.updateTime = updateTime;
        }
    }
}
