package cn.ctyun.apis.monitor;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询RDS实例mysql监控数据（数据粒度分钟级别)支持最近7天查询 */
public class Rds2GetMetricDataApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetMetricDataApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/metric-data",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetMetricDataResponse send(Credential credential, GetMetricDataRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.beginTime != null) {
            ctReq.addParam("beginTime", request.beginTime);
            request.beginTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.resId != null) {
            ctReq.addParam("resId", String.valueOf(request.resId));
            request.resId = null;
        }
        if (request.metricName != null) {
            ctReq.addParam("metricName", request.metricName);
            request.metricName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetMetricDataResponse.class);
    }

    public static class GetMetricDataRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 开始时间 yyyy-MM-dd HH:mm:ss */
        @JsonProperty("beginTime")
        private String beginTime;

        /** 结束时间 yyyy-MM-dd HH:mm:ss */
        @JsonProperty("endTime")
        private String endTime;

        /** 主机的resId */
        @JsonProperty("resId")
        private Integer resId;

        /**
         * | 指标枚举 | 监控指标 | 单位 | | -------------------------- | ----------------------------- |
         * -------------- | | cpu_util | CPU使用率 | % | | mem_util | 内存使用率 | % | | iops | IOPS |
         * counts/s | | bytes_in | 网络输入吞吐量 | bytes/s | | bytes_out | 网络输出吞吐量 | bytes/s | |
         * conn_count | 数据库总连接数 | counts | | conn_active_count | 当前活跃连接数 | counts | | qps | QPS |
         * queries/s | | tps | TPS | transactions/s | | disk_util | 磁盘利用率 | % | | innodb_buf_usage |
         * 缓冲池利用率 | % | | innodb_buf_hit | 缓冲池命中率 | % | | innodb_buf_dirty | 缓冲池脏块率 | % | |
         * innodb_reads | InnoDB读取吞吐量 | bytes/s | | innodb_writes | InnoDB写入吞吐量 | bytes/s | |
         * innodb_read_count | InnoDB文件读取频率 | counts/s | | innodb_write_count | InnoDB文件写入频率 |
         * counts/s | | innodb_log_write_req_count | InnoDB日志写请求频率 | counts/s | |
         * innodb_log_write_count | InnoDB日志物理写频率 | counts/s | | innodb_log_fsync_count |
         * InnoDB日志fsync()写频率 | counts/s | | temp_tbl_rate | 临时表创建速率 | counts/s | | comdml_del_count
         * | Delete语句执行频率 | queries/s | | comdml_ins_count | Insert语句执行频率 | queries/s | |
         * comdml_ins_sel_count | Insert_Select语句执行频率 | queries/s | | comdml_rep_count |
         * Replace语句执行频率 | queries/s | | comdml_rep_sel_count | Replace_Selection语句执行频率 | queries/s
         * | | comdml_sel_count | Select语句执行频率 | queries/s | | comdml_upd_count | Update语句执行频率 |
         * queries/s | | innodb_del_row_count | 行删除速率 | rows/s | | innodb_ins_row_count | 行插入速率 |
         * rows/s | | innodb_read_row_count | 行读取速率 | rows/s | | innodb_upd_row_count | 行更新速率 |
         * rows/s | | | | |
         */
        @JsonProperty("metricName")
        private String metricName;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }
    }

    public static class GetMetricDataResponse {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetMetricDataReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetMetricDataReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetMetricDataReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetMetricDataReturnObjResponse {
        /** 监控指标枚举 */
        @JsonProperty("metricName")
        private String metricName;

        /** 单位 */
        @JsonProperty("unit")
        private String unit;

        /** 返回监控步长 单位秒 */
        @JsonProperty("step")
        private Integer step;

        /** 监控指标数据 */
        @JsonProperty("data")
        private List<GetMetricDataReturnObjDataResponse> data;

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Integer getStep() {
            return this.step;
        }

        public void setStep(Integer step) {
            this.step = step;
        }

        public List<GetMetricDataReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<GetMetricDataReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class GetMetricDataReturnObjDataResponse {
        /** 监控采集时间点 */
        @JsonProperty("time")
        private String time;

        /** 监控指标数据 */
        @JsonProperty("value")
        private String value;

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
