package cn.ctyun.apis.monitor;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询RDS实例空间使用信息 */
public class Rds2GetInstanceUsageV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstanceUsageV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/usage-information",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceUsageV4Response send(Credential credential, GetInstanceUsageV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceUsageV4Response.class);
    }

    public static class GetInstanceUsageV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetInstanceUsageV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetInstanceUsageV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceUsageV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceUsageV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetInstanceUsageV4ReturnObjResponse {
        /** 磁盘大小单位G */
        @JsonProperty("totalSize")
        private String totalSize;

        /** 磁盘使用大小单位G */
        @JsonProperty("usedSize")
        private String usedSize;

        /** 磁盘可用大小 */
        @JsonProperty("availSize")
        private String availSize;

        /** 磁盘空间使用率% */
        @JsonProperty("diskUsedRated")
        private Integer diskUsedRated;

        /** 备份磁盘大小 单位G */
        @JsonProperty("backupDiskSize")
        private Integer backupDiskSize;

        /** 备份磁盘使用大小 */
        @JsonProperty("backupUsedDiskSize")
        private Double backupUsedDiskSize;

        /** 备份空间使用率% */
        @JsonProperty("backupDiskUsedRated")
        private Integer backupDiskUsedRated;

        /** 备份类型0: 没有设置备份1: 主机挂盘备份 2： 对象存储（不展示备份空间信息）3： 只读实例（不展示备份空间信息） */
        @JsonProperty("backupStoreType")
        private Integer backupStoreType;

        /** 机器ID */
        @JsonProperty("machineId")
        private Integer machineId;

        /** 内部实例ID */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        public String getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(String totalSize) {
            this.totalSize = totalSize;
        }

        public String getUsedSize() {
            return this.usedSize;
        }

        public void setUsedSize(String usedSize) {
            this.usedSize = usedSize;
        }

        public String getAvailSize() {
            return this.availSize;
        }

        public void setAvailSize(String availSize) {
            this.availSize = availSize;
        }

        public Integer getDiskUsedRated() {
            return this.diskUsedRated;
        }

        public void setDiskUsedRated(Integer diskUsedRated) {
            this.diskUsedRated = diskUsedRated;
        }

        public Integer getBackupDiskSize() {
            return this.backupDiskSize;
        }

        public void setBackupDiskSize(Integer backupDiskSize) {
            this.backupDiskSize = backupDiskSize;
        }

        public Double getBackupUsedDiskSize() {
            return this.backupUsedDiskSize;
        }

        public void setBackupUsedDiskSize(Double backupUsedDiskSize) {
            this.backupUsedDiskSize = backupUsedDiskSize;
        }

        public Integer getBackupDiskUsedRated() {
            return this.backupDiskUsedRated;
        }

        public void setBackupDiskUsedRated(Integer backupDiskUsedRated) {
            this.backupDiskUsedRated = backupDiskUsedRated;
        }

        public Integer getBackupStoreType() {
            return this.backupStoreType;
        }

        public void setBackupStoreType(Integer backupStoreType) {
            this.backupStoreType = backupStoreType;
        }

        public Integer getMachineId() {
            return this.machineId;
        }

        public void setMachineId(Integer machineId) {
            this.machineId = machineId;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }
    }
}
