package cn.ctyun.apis.monitor;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查根据性能参数查询某个实例性能监控数据 */
public class Rds2GetInstancePerformanceV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstancePerformanceV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/performance",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstancePerformanceV4Response send(
            Credential credential, GetInstancePerformanceV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.resId != null) {
            ctReq.addParam("resId", String.valueOf(request.resId));
            request.resId = null;
        }
        if (request.prodInstFlag != null) {
            ctReq.addParam("prodInstFlag", request.prodInstFlag);
            request.prodInstFlag = null;
        }
        if (request.prodInstSetName != null) {
            ctReq.addParam("prodInstSetName", request.prodInstSetName);
            request.prodInstSetName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstancePerformanceV4Response.class);
    }

    public static class GetInstancePerformanceV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 主机的resId */
        @JsonProperty("resId")
        private Integer resId;

        /** 标签 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        /** Set名称 */
        @JsonProperty("prodInstSetName")
        private String prodInstSetName;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }

        public String getProdInstSetName() {
            return this.prodInstSetName;
        }

        public void setProdInstSetName(String prodInstSetName) {
            this.prodInstSetName = prodInstSetName;
        }
    }

    public static class GetInstancePerformanceV4Response {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetInstancePerformanceV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstancePerformanceV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstancePerformanceV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetInstancePerformanceV4ReturnObjResponse {
        /** 实例标签 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        /** 实例set名称 */
        @JsonProperty("prodInstSetName")
        private String prodInstSetName;

        /** 主机信息 */
        @JsonProperty("host")
        private String host;

        /** 角色 */
        @JsonProperty("role")
        private String role;

        /** Cpu 系统使用率 */
        @JsonProperty("sys")
        private Integer sys;

        /** Cpu 用户使用率 */
        @JsonProperty("usr")
        private Integer usr;

        /** tps */
        @JsonProperty("tps")
        private Integer tps;

        /** qps */
        @JsonProperty("qps")
        private Integer qps;

        /** 写IO */
        @JsonProperty("wkbs")
        private Double wkbs;

        /** 读IO */
        @JsonProperty("rkbs")
        private Double rkbs;

        /** 数据库连接状态 */
        @JsonProperty("mysqlStatus")
        private Integer mysqlStatus;

        /** Threads_running 活跃数 */
        @JsonProperty("run")
        private Integer run;

        /** 连接数 */
        @JsonProperty("con")
        private Integer con;

        /** agent状态 */
        @JsonProperty("agentAlive")
        private Integer agentAlive;

        /** 创建时间戳 */
        @JsonProperty("createTime")
        private Long createTime;

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }

        public String getProdInstSetName() {
            return this.prodInstSetName;
        }

        public void setProdInstSetName(String prodInstSetName) {
            this.prodInstSetName = prodInstSetName;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public Integer getSys() {
            return this.sys;
        }

        public void setSys(Integer sys) {
            this.sys = sys;
        }

        public Integer getUsr() {
            return this.usr;
        }

        public void setUsr(Integer usr) {
            this.usr = usr;
        }

        public Integer getTps() {
            return this.tps;
        }

        public void setTps(Integer tps) {
            this.tps = tps;
        }

        public Integer getQps() {
            return this.qps;
        }

        public void setQps(Integer qps) {
            this.qps = qps;
        }

        public Double getWkbs() {
            return this.wkbs;
        }

        public void setWkbs(Double wkbs) {
            this.wkbs = wkbs;
        }

        public Double getRkbs() {
            return this.rkbs;
        }

        public void setRkbs(Double rkbs) {
            this.rkbs = rkbs;
        }

        public Integer getMysqlStatus() {
            return this.mysqlStatus;
        }

        public void setMysqlStatus(Integer mysqlStatus) {
            this.mysqlStatus = mysqlStatus;
        }

        public Integer getRun() {
            return this.run;
        }

        public void setRun(Integer run) {
            this.run = run;
        }

        public Integer getCon() {
            return this.con;
        }

        public void setCon(Integer con) {
            this.con = con;
        }

        public Integer getAgentAlive() {
            return this.agentAlive;
        }

        public void setAgentAlive(Integer agentAlive) {
            this.agentAlive = agentAlive;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }
    }
}
