package cn.ctyun.apis.log;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口更新实例的SQL洞察（SQL审计）规则。 */
public class Rds2UpdateAuditlogConfigV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2UpdateAuditlogConfigV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v2/open-api/audit-log/audit-config",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateAuditlogConfigV2Response send(
            Credential credential, UpdateAuditlogConfigV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateAuditlogConfigV2Response.class);
    }

    public static class UpdateAuditlogConfigV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 审计归档文件保留时长，单位天。范围：1到7 */
        @JsonProperty("auditLogRetentionDay")
        private Integer auditLogRetentionDay;

        /** 审计归档文件保留占用磁盘空间上限（百分比）。范围：1到30。 */
        @JsonProperty("retentionPercentage")
        private Integer retentionPercentage;

        /** 审计规则：1:全量审计（operations不做校验和更新）；0：用户自定义（operations不能为空）。 */
        @JsonProperty("auditType")
        private Integer auditType;

        /**
         * 审计支持的操作类型列表：<br>
         * DDL类型: CREATE, ALTER, DROP, RENAME, TRUNCATE, REPAIR, OPTIMIZE<br>
         * DML类型: INSERT, DELETE, UPDATE, REPLACE, SELECT<br>
         * DCL类型: CREATE_USER, DROP_USER, RENAME_USER, GRANT, REVOKE, ALTER_USER,
         * ALTER_USER_DEFAULT_ROLE<br>
         * 其他类型: BEGIN/COMMIT/ROLLBACK, PREPARED_STATEMENT, CALL_PROCEDURE, KILL, SET_OPTION,
         * CHANGE_DB, UNINSTALL_PLUGIN, INSTALL_PLUGIN, SHUTDOWN, SLAVE_START, SLAVE_STOP,
         * LOCK_TABLES, UNLOCK_TABLES, FLUSH, XA
         */
        @JsonProperty("operations")
        private List<String> operations;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getAuditLogRetentionDay() {
            return this.auditLogRetentionDay;
        }

        public void setAuditLogRetentionDay(Integer auditLogRetentionDay) {
            this.auditLogRetentionDay = auditLogRetentionDay;
        }

        public Integer getRetentionPercentage() {
            return this.retentionPercentage;
        }

        public void setRetentionPercentage(Integer retentionPercentage) {
            this.retentionPercentage = retentionPercentage;
        }

        public Integer getAuditType() {
            return this.auditType;
        }

        public void setAuditType(Integer auditType) {
            this.auditType = auditType;
        }

        public List<String> getOperations() {
            return this.operations;
        }

        public void setOperations(List<String> operations) {
            this.operations = operations;
        }
    }

    @ToString
    public static class UpdateAuditlogConfigV2Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateAuditlogConfigV2ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateAuditlogConfigV2ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateAuditlogConfigV2ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    @ToString
    public static class UpdateAuditlogConfigV2ReturnObjResponse {}
}
