package cn.ctyun.apis.log;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口查询实例的SQL洞察（SQL审计）文件内容 */
public class Rds2SearchAuditlogFileV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2SearchAuditlogFileV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/audit-log/search-file",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public SearchAuditlogFileV2Response send(
            Credential credential, SearchAuditlogFileV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.resId != null) {
            ctReq.addParam("resId", String.valueOf(request.resId));
            request.resId = null;
        }
        if (request.sourceIdentifier != null) {
            ctReq.addParam("sourceIdentifier", request.sourceIdentifier);
            request.sourceIdentifier = null;
        }
        if (request.keyWord != null) {
            ctReq.addParam("keyWord", request.keyWord);
            request.keyWord = null;
        }
        if (request.user != null) {
            ctReq.addParam("user", request.user);
            request.user = null;
        }
        if (request.db != null) {
            ctReq.addParam("db", request.db);
            request.db = null;
        }
        if (request.commandClass != null) {
            ctReq.addParam("commandClass", request.commandClass);
            request.commandClass = null;
        }
        if (request.status != null) {
            ctReq.addParam("status", request.status);
            request.status = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SearchAuditlogFileV2Response.class);
    }

    public static class SearchAuditlogFileV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 资源id */
        @JsonProperty("resId")
        private Integer resId;

        /** 文件唯一标识 */
        @JsonProperty("sourceIdentifier")
        private String sourceIdentifier;

        /** 关键字 */
        @JsonProperty("keyWord")
        private String keyWord;

        /** 用户名 */
        @JsonProperty("user")
        private String user;

        /** 数据库 */
        @JsonProperty("db")
        private String db;

        /** 操作类型：select,insert,update,delete,alter,create,drop,show,other */
        @JsonProperty("commandClass")
        private String commandClass;

        /** 状态 0成功 1失败 */
        @JsonProperty("status")
        private String status;

        /** 开始时间（建议等于或大于文件首行记录时间） */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间（建议等于或小于文件尾行记录时间） */
        @JsonProperty("endTime")
        private String endTime;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 单页记录条数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        public void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public String getKeyWord() {
            return this.keyWord;
        }

        public void setKeyWord(String keyWord) {
            this.keyWord = keyWord;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getCommandClass() {
            return this.commandClass;
        }

        public void setCommandClass(String commandClass) {
            this.commandClass = commandClass;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    @ToString
    public static class SearchAuditlogFileV2Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 分页信息 */
        @JsonProperty("returnObj")
        private SearchAuditlogFileV2ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public SearchAuditlogFileV2ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(SearchAuditlogFileV2ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    @ToString
    public static class SearchAuditlogFileV2ReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 最后一页 */
        @JsonProperty("lastPage")
        private Integer lastPage;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 结果集(每页显示的数据 */
        @JsonProperty("list")
        private List<SearchAuditlogFileV2ReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getLastPage() {
            return this.lastPage;
        }

        public void setLastPage(Integer lastPage) {
            this.lastPage = lastPage;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public Integer getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public List<SearchAuditlogFileV2ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<SearchAuditlogFileV2ReturnObjListResponse> list) {
            this.list = list;
        }
    }

    @ToString
    public static class SearchAuditlogFileV2ReturnObjListResponse {
        /** sql语句 */
        @JsonProperty("sqlText")
        private String sqlText;

        /** 命令类型 */
        @JsonProperty("commandClass")
        private String commandClass;

        /** 运行状态 0正常 1失败 */
        @JsonProperty("status")
        private Integer status;

        /** 用户名 */
        @JsonProperty("user")
        private String user;

        /** 数据库名 */
        @JsonProperty("db")
        private String db;

        /** 记录生成时间，格式为：yyyy-MM-dd HH:mm:ss */
        @JsonProperty("timestamp")
        private String timestamp;

        /** 记录标识 */
        @JsonProperty("record")
        private String record;

        /** 线程ID */
        @JsonProperty("connectionId")
        private String connectionId;

        public String getSqlText() {
            return this.sqlText;
        }

        public void setSqlText(String sqlText) {
            this.sqlText = sqlText;
        }

        public String getCommandClass() {
            return this.commandClass;
        }

        public void setCommandClass(String commandClass) {
            this.commandClass = commandClass;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public String getRecord() {
            return this.record;
        }

        public void setRecord(String record) {
            this.record = record;
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        public void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }
    }
}
