package cn.ctyun.apis.log;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口将SQL拦截规则迁移到指定实例。 */
public class Rds2MigrateFirewallSqlRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2MigrateFirewallSqlRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/firewall-sql/migrate",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public MigrateFirewallSqlRuleResponse send(
            Credential credential, MigrateFirewallSqlRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(MigrateFirewallSqlRuleResponse.class);
    }

    public static class MigrateFirewallSqlRuleRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 源实例ID */
        @JsonProperty("srcOuterProdInstId")
        private String srcOuterProdInstId;

        /** 目标实例ID（注意：迁移后会清空原有SQL拦截规则） */
        @JsonProperty("dstOuterProdInstId")
        private String dstOuterProdInstId;

        /** 需要迁移的sql规则id列表 */
        @JsonProperty("ids")
        private List<Integer> ids;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getSrcOuterProdInstId() {
            return this.srcOuterProdInstId;
        }

        public void setSrcOuterProdInstId(String srcOuterProdInstId) {
            this.srcOuterProdInstId = srcOuterProdInstId;
        }

        public String getDstOuterProdInstId() {
            return this.dstOuterProdInstId;
        }

        public void setDstOuterProdInstId(String dstOuterProdInstId) {
            this.dstOuterProdInstId = dstOuterProdInstId;
        }

        public List<Integer> getIds() {
            return this.ids;
        }

        public void setIds(List<Integer> ids) {
            this.ids = ids;
        }
    }

    @ToString
    public static class MigrateFirewallSqlRuleResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private MigrateFirewallSqlRuleReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public MigrateFirewallSqlRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(MigrateFirewallSqlRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    @ToString
    public static class MigrateFirewallSqlRuleReturnObjResponse {}
}
