package cn.ctyun.apis.log;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口查询实例的SQL洞察（SQL审计）文件列表 */
public class Rds2ListAuditlogFilesV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ListAuditlogFilesV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/audit-log/list-files",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListAuditlogFilesV2Response send(
            Credential credential, ListAuditlogFilesV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListAuditlogFilesV2Response.class);
    }

    public static class ListAuditlogFilesV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 单页记录条数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    @ToString
    public static class ListAuditlogFilesV2Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 分页信息 */
        @JsonProperty("returnObj")
        private ListAuditlogFilesV2ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListAuditlogFilesV2ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListAuditlogFilesV2ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    @ToString
    public static class ListAuditlogFilesV2ReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 最后一页 */
        @JsonProperty("lastPage")
        private Integer lastPage;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 结果集(每页显示的数据 */
        @JsonProperty("list")
        private List<ListAuditlogFilesV2ReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getLastPage() {
            return this.lastPage;
        }

        public void setLastPage(Integer lastPage) {
            this.lastPage = lastPage;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public Integer getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public List<ListAuditlogFilesV2ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ListAuditlogFilesV2ReturnObjListResponse> list) {
            this.list = list;
        }
    }

    @ToString
    public static class ListAuditlogFilesV2ReturnObjListResponse {
        /** 资源id */
        @JsonProperty("resId")
        private Integer resId;

        /** 资源名称 */
        @JsonProperty("resName")
        private String resName;

        /** 文件名称 */
        @JsonProperty("sourceFile")
        private String sourceFile;

        /** 文件唯一标识 */
        @JsonProperty("sourceIdentifier")
        private String sourceIdentifier;

        /** 文件首行记录时间 */
        @JsonProperty("sourceFirstTime")
        private String sourceFirstTime;

        /** 文件尾行记录时间 */
        @JsonProperty("sourceLastTime")
        private String sourceLastTime;

        /** 文件大小 */
        @JsonProperty("sourceSize")
        private String sourceSize;

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getResName() {
            return this.resName;
        }

        public void setResName(String resName) {
            this.resName = resName;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public void setSourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
        }

        public String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        public void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public String getSourceFirstTime() {
            return this.sourceFirstTime;
        }

        public void setSourceFirstTime(String sourceFirstTime) {
            this.sourceFirstTime = sourceFirstTime;
        }

        public String getSourceLastTime() {
            return this.sourceLastTime;
        }

        public void setSourceLastTime(String sourceLastTime) {
            this.sourceLastTime = sourceLastTime;
        }

        public String getSourceSize() {
            return this.sourceSize;
        }

        public void setSourceSize(String sourceSize) {
            this.sourceSize = sourceSize;
        }
    }
}
