package cn.ctyun.apis.log;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询实例慢日志详细情况。 */
public class Rds2GetSlowQueryDetailV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetSlowQueryDetailV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/slow-query/detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetSlowQueryDetailV4Response send(
            Credential credential, GetSlowQueryDetailV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.checksum != null) {
            ctReq.addParam("checksum", request.checksum);
            request.checksum = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetSlowQueryDetailV4Response.class);
    }

    public static class GetSlowQueryDetailV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 校验值 */
        @JsonProperty("checksum")
        private String checksum;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }
    }

    @ToString
    public static class GetSlowQueryDetailV4Response {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetSlowQueryDetailV4ReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetSlowQueryDetailV4ReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetSlowQueryDetailV4ReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    @ToString
    public static class GetSlowQueryDetailV4ReturnObjResponse {
        /** 执行sql模板 */
        @JsonProperty("fingerprint")
        private String fingerprint;

        /** 执行sql */
        @JsonProperty("sample")
        private String sample;

        /** 系统用户 */
        @JsonProperty("userMax")
        private String userMax;

        /** 首次出现时间 */
        @JsonProperty("tsMin")
        private Long tsMin;

        /** 最近出现时间 */
        @JsonProperty("tsMax")
        private Long tsMax;

        /** 查询次数 */
        @JsonProperty("tsCnt")
        private Double tsCnt;

        /** 主机IP */
        @JsonProperty("host")
        private String host;

        /** 慢日志路径 */
        @JsonProperty("slowquerylogfileMax")
        private String slowquerylogfileMax;

        /** 参加运算的记录总行数 */
        @JsonProperty("rowsExaminedMax")
        private Double rowsExaminedMax;

        /** 结果最大记录数 */
        @JsonProperty("rowsSentMax")
        private Double rowsSentMax;

        /** 锁等待时间最大 */
        @JsonProperty("lockTimeMax")
        private Double lockTimeMax;

        /** 查询最小时间 */
        @JsonProperty("queryTimeMin")
        private Double queryTimeMin;

        /** 首次出现时间戳 */
        @JsonProperty("firstSeen")
        private Long firstSeen;

        /** sql校验值 */
        @JsonProperty("checksumBig")
        private String checksumBig;

        /** 资源id */
        @JsonProperty("resId")
        private Integer resId;

        /** 端口 */
        @JsonProperty("port")
        private String port;

        /** 查询最大时间 */
        @JsonProperty("queryTimeMax")
        private Double queryTimeMax;

        /** 数据库名称 */
        @JsonProperty("dbMax")
        private String dbMax;

        public String getFingerprint() {
            return this.fingerprint;
        }

        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        public String getSample() {
            return this.sample;
        }

        public void setSample(String sample) {
            this.sample = sample;
        }

        public String getUserMax() {
            return this.userMax;
        }

        public void setUserMax(String userMax) {
            this.userMax = userMax;
        }

        public Long getTsMin() {
            return this.tsMin;
        }

        public void setTsMin(Long tsMin) {
            this.tsMin = tsMin;
        }

        public Long getTsMax() {
            return this.tsMax;
        }

        public void setTsMax(Long tsMax) {
            this.tsMax = tsMax;
        }

        public Double getTsCnt() {
            return this.tsCnt;
        }

        public void setTsCnt(Double tsCnt) {
            this.tsCnt = tsCnt;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getSlowquerylogfileMax() {
            return this.slowquerylogfileMax;
        }

        public void setSlowquerylogfileMax(String slowquerylogfileMax) {
            this.slowquerylogfileMax = slowquerylogfileMax;
        }

        public Double getRowsExaminedMax() {
            return this.rowsExaminedMax;
        }

        public void setRowsExaminedMax(Double rowsExaminedMax) {
            this.rowsExaminedMax = rowsExaminedMax;
        }

        public Double getRowsSentMax() {
            return this.rowsSentMax;
        }

        public void setRowsSentMax(Double rowsSentMax) {
            this.rowsSentMax = rowsSentMax;
        }

        public Double getLockTimeMax() {
            return this.lockTimeMax;
        }

        public void setLockTimeMax(Double lockTimeMax) {
            this.lockTimeMax = lockTimeMax;
        }

        public Double getQueryTimeMin() {
            return this.queryTimeMin;
        }

        public void setQueryTimeMin(Double queryTimeMin) {
            this.queryTimeMin = queryTimeMin;
        }

        public Long getFirstSeen() {
            return this.firstSeen;
        }

        public void setFirstSeen(Long firstSeen) {
            this.firstSeen = firstSeen;
        }

        public String getChecksumBig() {
            return this.checksumBig;
        }

        public void setChecksumBig(String checksumBig) {
            this.checksumBig = checksumBig;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public Double getQueryTimeMax() {
            return this.queryTimeMax;
        }

        public void setQueryTimeMax(Double queryTimeMax) {
            this.queryTimeMax = queryTimeMax;
        }

        public String getDbMax() {
            return this.dbMax;
        }

        public void setDbMax(String dbMax) {
            this.dbMax = dbMax;
        }
    }
}
