package cn.ctyun.apis.log;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询实例慢日志统计情况 */
public class Rds2GetSlowQueryByProdInstIdV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetSlowQueryByProdInstIdV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/slow-query", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetSlowQueryByProdInstIdV4Response send(
            Credential credential, GetSlowQueryByProdInstIdV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.beginTime != null) {
            ctReq.addParam("beginTime", request.beginTime);
            request.beginTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetSlowQueryByProdInstIdV4Response.class);
    }

    public static class GetSlowQueryByProdInstIdV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 慢查询当前页 不填默认1 1 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页面记录数 不填默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 开始时间 */
        @JsonProperty("beginTime")
        private String beginTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }
    }

    @ToString
    public static class GetSlowQueryByProdInstIdV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetSlowQueryByProdInstIdV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetSlowQueryByProdInstIdV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetSlowQueryByProdInstIdV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    @ToString
    public static class GetSlowQueryByProdInstIdV4ReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 结果集(每页显示的数据） */
        @JsonProperty("list")
        private List<GetSlowQueryByProdInstIdV4ReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public Integer getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public List<GetSlowQueryByProdInstIdV4ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetSlowQueryByProdInstIdV4ReturnObjListResponse> list) {
            this.list = list;
        }
    }

    @ToString
    public static class GetSlowQueryByProdInstIdV4ReturnObjListResponse {
        /** 执行sql */
        @JsonProperty("fingerprint")
        private String fingerprint;

        /** 系统用户 */
        @JsonProperty("userMax")
        private String userMax;

        /** 最后一次出现时间戳 */
        @JsonProperty("lastSeen")
        private Long lastSeen;

        /** 查询次数 */
        @JsonProperty("tsCnt")
        private Double tsCnt;

        /** 查询平均时间 */
        @JsonProperty("queryTimeAvg")
        private Double queryTimeAvg;

        /** 查询最大时间 */
        @JsonProperty("queryTimeMax")
        private Double queryTimeMax;

        /** 查询最小时间 */
        @JsonProperty("queryTimeMin")
        private Double queryTimeMin;

        /** 查询总时间 */
        @JsonProperty("queryTimeSum")
        private Double queryTimeSum;

        /** 锁时间总计 */
        @JsonProperty("lockTimeSum")
        private Double lockTimeSum;

        /** 锁等待时间最大 */
        @JsonProperty("lockTimeMax")
        private Double lockTimeMax;

        /** 锁等待时间最小 */
        @JsonProperty("lockTimeMin")
        private Double lockTimeMin;

        /** 资源id */
        @JsonProperty("serveridMax")
        private Integer serveridMax;

        /** sql校验值 */
        @JsonProperty("checksum")
        private String checksum;

        /** 数据库名称 */
        @JsonProperty("dbMax")
        private String dbMax;

        /** 实例标签 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        public String getFingerprint() {
            return this.fingerprint;
        }

        public void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        public String getUserMax() {
            return this.userMax;
        }

        public void setUserMax(String userMax) {
            this.userMax = userMax;
        }

        public Long getLastSeen() {
            return this.lastSeen;
        }

        public void setLastSeen(Long lastSeen) {
            this.lastSeen = lastSeen;
        }

        public Double getTsCnt() {
            return this.tsCnt;
        }

        public void setTsCnt(Double tsCnt) {
            this.tsCnt = tsCnt;
        }

        public Double getQueryTimeAvg() {
            return this.queryTimeAvg;
        }

        public void setQueryTimeAvg(Double queryTimeAvg) {
            this.queryTimeAvg = queryTimeAvg;
        }

        public Double getQueryTimeMax() {
            return this.queryTimeMax;
        }

        public void setQueryTimeMax(Double queryTimeMax) {
            this.queryTimeMax = queryTimeMax;
        }

        public Double getQueryTimeMin() {
            return this.queryTimeMin;
        }

        public void setQueryTimeMin(Double queryTimeMin) {
            this.queryTimeMin = queryTimeMin;
        }

        public Double getQueryTimeSum() {
            return this.queryTimeSum;
        }

        public void setQueryTimeSum(Double queryTimeSum) {
            this.queryTimeSum = queryTimeSum;
        }

        public Double getLockTimeSum() {
            return this.lockTimeSum;
        }

        public void setLockTimeSum(Double lockTimeSum) {
            this.lockTimeSum = lockTimeSum;
        }

        public Double getLockTimeMax() {
            return this.lockTimeMax;
        }

        public void setLockTimeMax(Double lockTimeMax) {
            this.lockTimeMax = lockTimeMax;
        }

        public Double getLockTimeMin() {
            return this.lockTimeMin;
        }

        public void setLockTimeMin(Double lockTimeMin) {
            this.lockTimeMin = lockTimeMin;
        }

        public Integer getServeridMax() {
            return this.serveridMax;
        }

        public void setServeridMax(Integer serveridMax) {
            this.serveridMax = serveridMax;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public String getDbMax() {
            return this.dbMax;
        }

        public void setDbMax(String dbMax) {
            this.dbMax = dbMax;
        }

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }
    }
}
