package cn.ctyun.apis.log;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用接口查询操作记录 */
public class Rds2GetOperationRecordApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetOperationRecordApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/operations/tenant",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetOperationRecordResponse send(Credential credential, GetOperationRecordRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetOperationRecordResponse.class);
    }

    public static class GetOperationRecordRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 外部实例id列表 */
        @JsonProperty("outerProdInstIdList")
        private List<String> outerProdInstIdList;

        /** 操作记录Code列表 */
        @JsonProperty("functionCode")
        private List<String> functionCode;

        /** 结果 0成功 1失败 */
        @JsonProperty("result")
        private Integer result;

        /** 用户名 */
        @JsonProperty("userName")
        private String userName;

        /** 当前页 默认1 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页大小 默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 开始时间 */
        @JsonProperty("beginTime")
        private String beginTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getOuterProdInstIdList() {
            return this.outerProdInstIdList;
        }

        public void setOuterProdInstIdList(List<String> outerProdInstIdList) {
            this.outerProdInstIdList = outerProdInstIdList;
        }

        public List<String> getFunctionCode() {
            return this.functionCode;
        }

        public void setFunctionCode(List<String> functionCode) {
            this.functionCode = functionCode;
        }

        public Integer getResult() {
            return this.result;
        }

        public void setResult(Integer result) {
            this.result = result;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }
    }

    public static class GetOperationRecordResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetOperationRecordReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetOperationRecordReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetOperationRecordReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetOperationRecordReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Boolean navigatePages;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 结果集(每页显示的数据） */
        @JsonProperty("list")
        private List<GetOperationRecordReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Boolean getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Boolean navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public Integer getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public List<GetOperationRecordReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetOperationRecordReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class GetOperationRecordReturnObjListResponse {
        /** 产品实例ID */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 实例名 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 操作记录Code */
        @JsonProperty("functionCode")
        private String functionCode;

        /** 账户类型 */
        @JsonProperty("accountType")
        private Integer accountType;

        /** 返回的errorCode */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 调用时间 */
        @JsonProperty("updateTime")
        private String updateTime;

        /** 用户名 */
        @JsonProperty("userName")
        private String userName;

        /** 用户ID */
        @JsonProperty("userId")
        private Integer userId;

        /** 资源租户ID */
        @JsonProperty("resourceTenantId")
        private Integer resourceTenantId;

        /** 调用url */
        @JsonProperty("url")
        private String url;

        /** 接口返回信息 */
        @JsonProperty("resultMsg")
        private String resultMsg;

        /** 接口返回Status */
        @JsonProperty("resultStatus")
        private String resultStatus;

        /** 结果 0成功 1失败 */
        @JsonProperty("result")
        private Integer result;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 租户名 */
        @JsonProperty("tenantName")
        private String tenantName;

        /** 记录创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 租户ID */
        @JsonProperty("tenantId")
        private Integer tenantId;

        /** 操作记录ID */
        @JsonProperty("id")
        private Integer id;

        /** 请求信息 */
        @JsonProperty("requestData")
        private String requestData;

        /** 操作记录所属类型 */
        @JsonProperty("resourceType")
        private String resourceType;

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getFunctionCode() {
            return this.functionCode;
        }

        public void setFunctionCode(String functionCode) {
            this.functionCode = functionCode;
        }

        public Integer getAccountType() {
            return this.accountType;
        }

        public void setAccountType(Integer accountType) {
            this.accountType = accountType;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(String updateTime) {
            this.updateTime = updateTime;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public Integer getResourceTenantId() {
            return this.resourceTenantId;
        }

        public void setResourceTenantId(Integer resourceTenantId) {
            this.resourceTenantId = resourceTenantId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getResultMsg() {
            return this.resultMsg;
        }

        public void setResultMsg(String resultMsg) {
            this.resultMsg = resultMsg;
        }

        public String getResultStatus() {
            return this.resultStatus;
        }

        public void setResultStatus(String resultStatus) {
            this.resultStatus = resultStatus;
        }

        public Integer getResult() {
            return this.result;
        }

        public void setResult(Integer result) {
            this.result = result;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getTenantName() {
            return this.tenantName;
        }

        public void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(Integer tenantId) {
            this.tenantId = tenantId;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getRequestData() {
            return this.requestData;
        }

        public void setRequestData(String requestData) {
            this.requestData = requestData;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }
    }
}
