package cn.ctyun.apis.log;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口查询实例的SQL洞察（SQL审计）规则。 */
public class Rds2GetAuditlogConfigV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetAuditlogConfigV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/audit-log/config",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetAuditlogConfigV2Response send(
            Credential credential, GetAuditlogConfigV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetAuditlogConfigV2Response.class);
    }

    public static class GetAuditlogConfigV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    @ToString
    public static class GetAuditlogConfigV2Response {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetAuditlogConfigV2ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetAuditlogConfigV2ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetAuditlogConfigV2ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    @ToString
    public static class GetAuditlogConfigV2ReturnObjResponse {
        /** 审计归档文件保留时长，单位天 */
        @JsonProperty("auditLogRetentionDay")
        private Integer auditLogRetentionDay;

        /** 审计归档文件保留占用磁盘空间上限（百分比） */
        @JsonProperty("retentionPercentage")
        private Integer retentionPercentage;

        /** 审计规则：1:全量审计；0：用户自定义（自定义时，operations有效） */
        @JsonProperty("auditType")
        private Integer auditType;

        /** 审计开关状态。0：已关闭；1：已开启 */
        @JsonProperty("status")
        private Integer status;

        /** 审计支持的操作类型列表 */
        @JsonProperty("operations")
        private List<String> operations;

        public Integer getAuditLogRetentionDay() {
            return this.auditLogRetentionDay;
        }

        public void setAuditLogRetentionDay(Integer auditLogRetentionDay) {
            this.auditLogRetentionDay = auditLogRetentionDay;
        }

        public Integer getRetentionPercentage() {
            return this.retentionPercentage;
        }

        public void setRetentionPercentage(Integer retentionPercentage) {
            this.retentionPercentage = retentionPercentage;
        }

        public Integer getAuditType() {
            return this.auditType;
        }

        public void setAuditType(Integer auditType) {
            this.auditType = auditType;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public List<String> getOperations() {
            return this.operations;
        }

        public void setOperations(List<String> operations) {
            this.operations = operations;
        }
    }
}
