package cn.ctyun.apis.log;


import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取云日志配置列表 */
public class Rds2CloudLogConfListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CloudLogConfListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/cloud-log/list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CloudLogConfListResponse send(Credential credential, CloudLogConfListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CloudLogConfListResponse.class);
    }

    public static class CloudLogConfListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 慢查询当前页 不填默认1 1 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页面记录数 不填默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class CloudLogConfListResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CloudLogConfListReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CloudLogConfListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CloudLogConfListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CloudLogConfListReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 下一页 */
        @JsonProperty("nextPage")
        private Integer nextPage;

        /** 页面上显示的最后一个页码 */
        @JsonProperty("navigateLastPage")
        private Integer navigateLastPage;

        /** 页面显示的第一个页码 */
        @JsonProperty("navigateFirstPage")
        private Integer navigateFirstPage;

        /** 结果集(每页显示的数据） */
        @JsonProperty("list")
        private List<CloudLogConfListReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public Integer getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(Integer nextPage) {
            this.nextPage = nextPage;
        }

        public Integer getNavigateLastPage() {
            return this.navigateLastPage;
        }

        public void setNavigateLastPage(Integer navigateLastPage) {
            this.navigateLastPage = navigateLastPage;
        }

        public Integer getNavigateFirstPage() {
            return this.navigateFirstPage;
        }

        public void setNavigateFirstPage(Integer navigateFirstPage) {
            this.navigateFirstPage = navigateFirstPage;
        }

        public List<CloudLogConfListReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<CloudLogConfListReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class CloudLogConfListReturnObjListResponse {
        /** 慢日志组名 */
        @JsonProperty("slowLogGroupName")
        private String slowLogGroupName;

        /** 实例订单状态 */
        @JsonProperty("prodOrderStatus")
        private Integer prodOrderStatus;

        /** 错误日志组名 */
        @JsonProperty("errorLogGroupName")
        private String errorLogGroupName;

        /** 慢日志组编码 */
        @JsonProperty("slowLogGroup")
        private String slowLogGroup;

        /** 实例名 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 实例是否正常 */
        @JsonProperty("alive")
        private Integer alive;

        /** 产品实例ID */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 实例引擎版本 */
        @JsonProperty("prodDbEngine")
        private String prodDbEngine;

        /** 是否授权 0:未授权 1:已授权 */
        @JsonProperty("authStatus")
        private Integer authStatus;

        /** 错误日志组编码 */
        @JsonProperty("errorLogGroup")
        private String errorLogGroup;

        /** 错误日志配置路径 */
        @JsonProperty("errorLogPath")
        private String errorLogPath;

        /** 慢日志流编码 */
        @JsonProperty("slowLogStream")
        private String slowLogStream;

        /** 配置记录更新时间 */
        @JsonProperty("updateTime")
        private String updateTime;

        /** 慢日志配置路径 */
        @JsonProperty("slowLogPath")
        private String slowLogPath;

        /** 错误日志流名 */
        @JsonProperty("errorLogStreamName")
        private String errorLogStreamName;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 慢日志流名 */
        @JsonProperty("slowLogStreamName")
        private String slowLogStreamName;

        /** 错误日志配置状态 -1:未配置 0:安装中 1:运行中 2:安装失败 3:删除中 4:删除失败 */
        @JsonProperty("errorLogStatus")
        private Integer errorLogStatus;

        /** 配置记录创建时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** 实例运行状态 */
        @JsonProperty("prodRunningStatus")
        private Integer prodRunningStatus;

        /** 慢日志配置状态 -1:未配置 0:安装中 1:运行中 2:安装失败 3:删除中 4:删除失败 */
        @JsonProperty("slowLogStatus")
        private Integer slowLogStatus;

        /** 配置id */
        @JsonProperty("id")
        private Integer id;

        /** 错误日志流编码 */
        @JsonProperty("errorLogStream")
        private String errorLogStream;

        public String getSlowLogGroupName() {
            return this.slowLogGroupName;
        }

        public void setSlowLogGroupName(String slowLogGroupName) {
            this.slowLogGroupName = slowLogGroupName;
        }

        public Integer getProdOrderStatus() {
            return this.prodOrderStatus;
        }

        public void setProdOrderStatus(Integer prodOrderStatus) {
            this.prodOrderStatus = prodOrderStatus;
        }

        public String getErrorLogGroupName() {
            return this.errorLogGroupName;
        }

        public void setErrorLogGroupName(String errorLogGroupName) {
            this.errorLogGroupName = errorLogGroupName;
        }

        public String getSlowLogGroup() {
            return this.slowLogGroup;
        }

        public void setSlowLogGroup(String slowLogGroup) {
            this.slowLogGroup = slowLogGroup;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public Integer getAlive() {
            return this.alive;
        }

        public void setAlive(Integer alive) {
            this.alive = alive;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getProdDbEngine() {
            return this.prodDbEngine;
        }

        public void setProdDbEngine(String prodDbEngine) {
            this.prodDbEngine = prodDbEngine;
        }

        public Integer getAuthStatus() {
            return this.authStatus;
        }

        public void setAuthStatus(Integer authStatus) {
            this.authStatus = authStatus;
        }

        public String getErrorLogGroup() {
            return this.errorLogGroup;
        }

        public void setErrorLogGroup(String errorLogGroup) {
            this.errorLogGroup = errorLogGroup;
        }

        public String getErrorLogPath() {
            return this.errorLogPath;
        }

        public void setErrorLogPath(String errorLogPath) {
            this.errorLogPath = errorLogPath;
        }

        public String getSlowLogStream() {
            return this.slowLogStream;
        }

        public void setSlowLogStream(String slowLogStream) {
            this.slowLogStream = slowLogStream;
        }

        public String getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(String updateTime) {
            this.updateTime = updateTime;
        }

        public String getSlowLogPath() {
            return this.slowLogPath;
        }

        public void setSlowLogPath(String slowLogPath) {
            this.slowLogPath = slowLogPath;
        }

        public String getErrorLogStreamName() {
            return this.errorLogStreamName;
        }

        public void setErrorLogStreamName(String errorLogStreamName) {
            this.errorLogStreamName = errorLogStreamName;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getSlowLogStreamName() {
            return this.slowLogStreamName;
        }

        public void setSlowLogStreamName(String slowLogStreamName) {
            this.slowLogStreamName = slowLogStreamName;
        }

        public Integer getErrorLogStatus() {
            return this.errorLogStatus;
        }

        public void setErrorLogStatus(Integer errorLogStatus) {
            this.errorLogStatus = errorLogStatus;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public Integer getProdRunningStatus() {
            return this.prodRunningStatus;
        }

        public void setProdRunningStatus(Integer prodRunningStatus) {
            this.prodRunningStatus = prodRunningStatus;
        }

        public Integer getSlowLogStatus() {
            return this.slowLogStatus;
        }

        public void setSlowLogStatus(Integer slowLogStatus) {
            this.slowLogStatus = slowLogStatus;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getErrorLogStream() {
            return this.errorLogStream;
        }

        public void setErrorLogStream(String errorLogStream) {
            this.errorLogStream = errorLogStream;
        }
    }
}

