package cn.ctyun.apis.log;


import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 配置云日志服务 */
public class Rds2CloudLogConfApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CloudLogConfApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/cloud-log/config",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CloudLogConfResponse send(Credential credential, CloudLogConfRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CloudLogConfResponse.class);
    }

    public static class CloudLogConfRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 日志类型 error:错误日志 slow:慢日志 */
        @JsonProperty("logType")
        private String logType;

        /** 慢日志组编码 配置慢日志时不能为空 */
        @JsonProperty("slowLogGroup")
        private String slowLogGroup;

        /** 慢日志流编码 配置慢日志时不能为空 */
        @JsonProperty("slowLogStream")
        private String slowLogStream;

        /** 慢日志组名 配置慢日志时不能为空 */
        @JsonProperty("slowLogGroupName")
        private String slowLogGroupName;

        /** 慢日志流名 配置慢日志时不能为空 */
        @JsonProperty("slowLogStreamName")
        private String slowLogStreamName;

        /** 错误日志组编码 配置错误日志时不能为空 */
        @JsonProperty("errorLogGroup")
        private String errorLogGroup;

        /** 错误日志流编码 配置错误日志时不能为空 */
        @JsonProperty("errorLogStream")
        private String errorLogStream;

        /** 错误日志组名 配置错误日志时不能为空 */
        @JsonProperty("errorLogGroupName")
        private String errorLogGroupName;

        /** 错误日志流名 配置错误日志时不能为空 */
        @JsonProperty("errorLogStreamName")
        private String errorLogStreamName;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getLogType() {
            return this.logType;
        }

        public void setLogType(String logType) {
            this.logType = logType;
        }

        public String getSlowLogGroup() {
            return this.slowLogGroup;
        }

        public void setSlowLogGroup(String slowLogGroup) {
            this.slowLogGroup = slowLogGroup;
        }

        public String getSlowLogStream() {
            return this.slowLogStream;
        }

        public void setSlowLogStream(String slowLogStream) {
            this.slowLogStream = slowLogStream;
        }

        public String getSlowLogGroupName() {
            return this.slowLogGroupName;
        }

        public void setSlowLogGroupName(String slowLogGroupName) {
            this.slowLogGroupName = slowLogGroupName;
        }

        public String getSlowLogStreamName() {
            return this.slowLogStreamName;
        }

        public void setSlowLogStreamName(String slowLogStreamName) {
            this.slowLogStreamName = slowLogStreamName;
        }

        public String getErrorLogGroup() {
            return this.errorLogGroup;
        }

        public void setErrorLogGroup(String errorLogGroup) {
            this.errorLogGroup = errorLogGroup;
        }

        public String getErrorLogStream() {
            return this.errorLogStream;
        }

        public void setErrorLogStream(String errorLogStream) {
            this.errorLogStream = errorLogStream;
        }

        public String getErrorLogGroupName() {
            return this.errorLogGroupName;
        }

        public void setErrorLogGroupName(String errorLogGroupName) {
            this.errorLogGroupName = errorLogGroupName;
        }

        public String getErrorLogStreamName() {
            return this.errorLogStreamName;
        }

        public void setErrorLogStreamName(String errorLogStreamName) {
            this.errorLogStreamName = errorLogStreamName;
        }
    }

    public static class CloudLogConfResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}

