package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询实例可切换的VPC、子网及安全组信息 */
public class Rds2SwitchableVpcListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2SwitchableVpcListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/switchable-vpc-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public SwitchableVpcListResponse send(Credential credential, SwitchableVpcListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SwitchableVpcListResponse.class);
    }

    public static class SwitchableVpcListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class SwitchableVpcListResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<SwitchableVpcListReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<SwitchableVpcListReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<SwitchableVpcListReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class SwitchableVpcListReturnObjResponse {
        /** vpcId */
        @JsonProperty("vpcId")
        private String vpcId;

        /** vpc名称 */
        @JsonProperty("vpcName")
        private String vpcName;

        /** vpc主网段（ipv4） */
        @JsonProperty("vpcCIDR")
        private String vpcCIDR;

        /** vpc扩展网段 */
        @JsonProperty("secondaryCIDRs")
        private List<String> secondaryCIDRs;

        /** 当前vpc下可切换的子网列表 */
        @JsonProperty("availableSubnetList")
        private List<SwitchableVpcListReturnObjAvailableSubnetListResponse> availableSubnetList;

        /** 当前vpc下的安全组列表 */
        @JsonProperty("securityGroupList")
        private List<SwitchableVpcListReturnObjSecurityGroupListResponse> securityGroupList;

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public String getVpcCIDR() {
            return this.vpcCIDR;
        }

        public void setVpcCIDR(String vpcCIDR) {
            this.vpcCIDR = vpcCIDR;
        }

        public List<String> getSecondaryCIDRs() {
            return this.secondaryCIDRs;
        }

        public void setSecondaryCIDRs(List<String> secondaryCIDRs) {
            this.secondaryCIDRs = secondaryCIDRs;
        }

        public List<SwitchableVpcListReturnObjAvailableSubnetListResponse>
                getAvailableSubnetList() {
            return this.availableSubnetList;
        }

        public void setAvailableSubnetList(
                List<SwitchableVpcListReturnObjAvailableSubnetListResponse> availableSubnetList) {
            this.availableSubnetList = availableSubnetList;
        }

        public List<SwitchableVpcListReturnObjSecurityGroupListResponse> getSecurityGroupList() {
            return this.securityGroupList;
        }

        public void setSecurityGroupList(
                List<SwitchableVpcListReturnObjSecurityGroupListResponse> securityGroupList) {
            this.securityGroupList = securityGroupList;
        }
    }

    public static class SwitchableVpcListReturnObjAvailableSubnetListResponse {
        /** 子网id */
        @JsonProperty("subnetId")
        private String subnetId;

        /** 子网名称 */
        @JsonProperty("subnetName")
        private String subnetName;

        /** 子网可用ip数量 */
        @JsonProperty("availableIpCount")
        private Integer availableIpCount;

        @JsonProperty("ipv6Cidr")
        private String ipv6Cidr;

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public String getSubnetName() {
            return this.subnetName;
        }

        public void setSubnetName(String subnetName) {
            this.subnetName = subnetName;
        }

        public Integer getAvailableIpCount() {
            return this.availableIpCount;
        }

        public void setAvailableIpCount(Integer availableIpCount) {
            this.availableIpCount = availableIpCount;
        }

        public String getIpv6Cidr() {
            return ipv6Cidr;
        }

        public void setIpv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
        }
    }

    public static class SwitchableVpcListReturnObjSecurityGroupListResponse {
        /** 安全组id */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** 安全组名称 */
        @JsonProperty("securityGroupName")
        private String securityGroupName;

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }
    }
}
