package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询主从切换记录 */
public class Rds2SwitchInstanceRecordV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2SwitchInstanceRecordV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/switch-instance-record",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public SwitchInstanceRecordV4Response send(
            Credential credential, SwitchInstanceRecordV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.freason != null) {
            ctReq.addParam("freason", request.freason);
            request.freason = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SwitchInstanceRecordV4Response.class);
    }

    public static class SwitchInstanceRecordV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 单页记录条数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 标签列表 manaul 手工切换 failover 一致性切换 unconsfailover 非一致切换 ignore 下发切换任务实际条件不满足未切换 */
        @JsonProperty("freason")
        private String freason;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getFreason() {
            return this.freason;
        }

        public void setFreason(String freason) {
            this.freason = freason;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class SwitchInstanceRecordV4Response {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 分页信息 */
        @JsonProperty("returnObj")
        private SwitchInstanceRecordV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public SwitchInstanceRecordV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(SwitchInstanceRecordV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class SwitchInstanceRecordV4ReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 所有导航页号 */
        @JsonProperty("navigatepageNums")
        private List<Integer> navigatepageNums;

        /** 结果集(每页显示的数据） */
        @JsonProperty("list")
        private List<SwitchInstanceRecordV4ReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public List<Integer> getNavigatepageNums() {
            return this.navigatepageNums;
        }

        public void setNavigatepageNums(List<Integer> navigatepageNums) {
            this.navigatepageNums = navigatepageNums;
        }

        public List<SwitchInstanceRecordV4ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<SwitchInstanceRecordV4ReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class SwitchInstanceRecordV4ReturnObjListResponse {
        /** 当前主从情况 */
        @JsonProperty("fcurstat")
        private String fcurstat;

        /** 先去主从情况 */
        @JsonProperty("flaststat")
        private String flaststat;

        /** 实例名称 */
        @JsonProperty("prodInstSetName")
        private String prodInstSetName;

        /** 切换开始时间 */
        @JsonProperty("fstarttime")
        private Long fstarttime;

        /** 切换结束时间 */
        @JsonProperty("fendtime")
        private Long fendtime;

        /** 切换记录id */
        @JsonProperty("switchId")
        private Integer switchId;

        /** 切换原因 manaul 手工切换 failover 一致性切换 unconsfailover 非一致切换 ignore 下发切换任务实际条件不满足未切换 */
        @JsonProperty("freason")
        private String freason;

        public String getFcurstat() {
            return this.fcurstat;
        }

        public void setFcurstat(String fcurstat) {
            this.fcurstat = fcurstat;
        }

        public String getFlaststat() {
            return this.flaststat;
        }

        public void setFlaststat(String flaststat) {
            this.flaststat = flaststat;
        }

        public String getProdInstSetName() {
            return this.prodInstSetName;
        }

        public void setProdInstSetName(String prodInstSetName) {
            this.prodInstSetName = prodInstSetName;
        }

        public Long getFstarttime() {
            return this.fstarttime;
        }

        public void setFstarttime(Long fstarttime) {
            this.fstarttime = fstarttime;
        }

        public Long getFendtime() {
            return this.fendtime;
        }

        public void setFendtime(Long fendtime) {
            this.fendtime = fendtime;
        }

        public Integer getSwitchId() {
            return this.switchId;
        }

        public void setSwitchId(Integer switchId) {
            this.switchId = switchId;
        }

        public String getFreason() {
            return this.freason;
        }

        public void setFreason(String freason) {
            this.freason = freason;
        }
    }
}
