package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 切换RDS实例的主备实例，该任务为异步任务，需要查询任务状态可以通过“查询主从切换记录”接口获取任务执行结果。 */
public class Rds2SwitchDBInstanceHAV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2SwitchDBInstanceHAV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/instance/switch-db-instance-ha",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public SwitchDBInstanceHAV4Response send(
            Credential credential, SwitchDBInstanceHAV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SwitchDBInstanceHAV4Response.class);
    }

    public static class SwitchDBInstanceHAV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 新主的主机resId */
        @JsonProperty("newMasterResId")
        private Integer newMasterResId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getNewMasterResId() {
            return this.newMasterResId;
        }

        public void setNewMasterResId(Integer newMasterResId) {
            this.newMasterResId = newMasterResId;
        }
    }

    public static class SwitchDBInstanceHAV4Response {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private SwitchDBInstanceHAV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public SwitchDBInstanceHAV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(SwitchDBInstanceHAV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class SwitchDBInstanceHAV4ReturnObjResponse {}
}
