package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/**
 * 设置性能自动扩缩容
 */
public class Rds2SetAutomaticPerformanceScalingApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2SetAutomaticPerformanceScalingApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/RDS2/v1/open-api/instance/cpu-auto-scaling",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request    请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public SetAutomaticPerformanceScalingResponse send(
            Credential credential, SetAutomaticPerformanceScalingRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SetAutomaticPerformanceScalingResponse.class);
    }

    public static class SetAutomaticPerformanceScalingRequest {
        /**
         * 项目id
         */
        @JsonProperty("project-id")
        private String projectId;

        /**
         * 实例id （和参数outerProdInstId保持一致）
         */
        @JsonProperty("inst-id")
        private String instId;

        /**
         * 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /**
         * 操作（扩容 expand 或缩容 degrade）
         */
        @JsonProperty("method")
        private String method;

        /**
         * 开启状态，0-开启，1-关闭
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 扩容上限/缩容下限
         */
        @JsonProperty("limit")
        private String limit;

        /**
         * 触发阈值，扩容（可选范围：0.5-0.9），缩容（可选范围：0.1-0.5）
         */
        @JsonProperty("threshold")
        private String threshold;

        /**
         * 观察窗口期，扩容默认5m（单位：分钟。可选范围：5m,30m,60m），缩容默认1d（单位：天。可选范围1d-7d）
         */
        @JsonProperty("duration")
        private String duration;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getLimit() {
            return this.limit;
        }

        public void setLimit(String limit) {
            this.limit = limit;
        }

        public String getThreshold() {
            return this.threshold;
        }

        public void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        public String getDuration() {
            return this.duration;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }
    }

    public static class SetAutomaticPerformanceScalingResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /**
         * 返回信息
         */
        @JsonProperty("message")
        private String message;

        /**
         * 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空
         */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "SetAutomaticPerformanceScalingResponse{" +
                    "statusCode=" + statusCode +
                    ", message='" + message + '\'' +
                    ", error='" + error + '\'' +
                    '}';
        }
    }
}
