package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/**
 * 开通购买自研云数据库rds实例，提供回收站恢复新实例
 */
public class Rds2RebuildInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2RebuildInstanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/order/rebuild",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request    请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RebuildInstanceResponse send(Credential credential, RebuildInstanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RebuildInstanceResponse.class);
    }

    public static class RebuildInstanceRequest {
        /**
         * 项目id
         */
        @JsonProperty("project-id")
        private String projectId;

        /**
         * 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 计费模式： 1是包周期，2是按需
         */
        @JsonProperty("billMode")
        private String billMode;

        /**
         * 购买时长：单位月(若计费为包周期则必填，否则选填)
         */
        @JsonProperty("period")
        private Integer period;

        /**
         * 源实例ID，跨域恢复到新实例有用到
         */
        @JsonProperty("sourceInstId")
        private String sourceInstId;

        /**
         * 指定vip，默认不指定
         */
        @JsonProperty("appointVip")
        private String appointVip;

        /**
         * 集群名称，默认则取原实例配置
         */
        @JsonProperty("name")
        private String name;

        /**
         * 管理员密码（RSA公钥加密）,默认随机
         */
        @JsonProperty("password")
        private String password;

        /**
         * 购买数量(范围:1-50)，默认1
         */
        @JsonProperty("count")
        private Integer count;

        /**
         * 自动续订状态 （0-不自动续订,1-自动续订），默认自动续订
         */
        @JsonProperty("autoRenewStatus")
        private Integer autoRenewStatus;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getBillMode() {
            return this.billMode;
        }

        public void setBillMode(String billMode) {
            this.billMode = billMode;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public String getSourceInstId() {
            return this.sourceInstId;
        }

        public void setSourceInstId(String sourceInstId) {
            this.sourceInstId = sourceInstId;
        }

        public String getAppointVip() {
            return this.appointVip;
        }

        public void setAppointVip(String appointVip) {
            this.appointVip = appointVip;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(Integer autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }
    }

    public static class RebuildInstanceResponse {
        /**
         * 接口状态码，参考下方状态码
         */
        @JsonProperty("statusCode")
        private String statusCode;

        /**
         * 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空
         */
        @JsonProperty("error")
        private String error;

        /**
         * 描述信息
         */
        @JsonProperty("message")
        private String message;

        /**
         * 返回对象
         */
        @JsonProperty("returnObj")
        private RebuildInstanceReturnObjResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public RebuildInstanceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(RebuildInstanceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        @Override
        public String toString() {
            return "RebuildInstanceResponse{" +
                    "statusCode='" + statusCode + '\'' +
                    ", error='" + error + '\'' +
                    ", message='" + message + '\'' +
                    ", returnObj=" + returnObj +
                    '}';
        }
    }

    public static class RebuildInstanceReturnObjResponse {
        /**
         * 订单id
         */
        @JsonProperty("orderId")
        private String orderId;

        public String getOrderId() {
            return this.orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public String toString() {
            return "RebuildInstanceReturnObjResponse{" +
                    "orderId='" + orderId + '\'' +
                    '}';
        }
    }
}
