package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询只读实例延迟信息 */
public class Rds2ReadInstanceDelayV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ReadInstanceDelayV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/read-instance-delay",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ReadInstanceDelayV4Response send(
            Credential credential, ReadInstanceDelayV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.parentOuterProdInstId != null) {
            ctReq.addParam("parentOuterProdInstId", request.parentOuterProdInstId);
            request.parentOuterProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ReadInstanceDelayV4Response.class);
    }

    public static class ReadInstanceDelayV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 只读实例ID outerProdInstId与parentOuterProdInstId至少填一个即可 */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 父实例id */
        @JsonProperty("parentOuterProdInstId")
        private String parentOuterProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getParentOuterProdInstId() {
            return this.parentOuterProdInstId;
        }

        public void setParentOuterProdInstId(String parentOuterProdInstId) {
            this.parentOuterProdInstId = parentOuterProdInstId;
        }
    }

    public static class ReadInstanceDelayV4Response {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<ReadInstanceDelayV4ReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<ReadInstanceDelayV4ReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ReadInstanceDelayV4ReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ReadInstanceDelayV4ReturnObjResponse {
        /** 主库binlog当前位置 */
        @JsonProperty("masterBinlogPos")
        private Long masterBinlogPos;

        /** 从库binlog当前位置 */
        @JsonProperty("currentBinlogPos")
        private Long currentBinlogPos;

        /** 延迟 单位毫秒 */
        @JsonProperty("delay")
        private Integer delay;

        /** 主库binlog当前文件名 */
        @JsonProperty("masterBinlogFile")
        private String masterBinlogFile;

        /** 从库binlog当前文件名 */
        @JsonProperty("currentBinlogFile")
        private String currentBinlogFile;

        /** 只读实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 父实例id */
        @JsonProperty("parentOuterProdInstId")
        private String parentOuterProdInstId;

        /** 最近监控实际 */
        @JsonProperty("createTime")
        private String createTime;

        public Long getMasterBinlogPos() {
            return this.masterBinlogPos;
        }

        public void setMasterBinlogPos(Long masterBinlogPos) {
            this.masterBinlogPos = masterBinlogPos;
        }

        public Long getCurrentBinlogPos() {
            return this.currentBinlogPos;
        }

        public void setCurrentBinlogPos(Long currentBinlogPos) {
            this.currentBinlogPos = currentBinlogPos;
        }

        public Integer getDelay() {
            return this.delay;
        }

        public void setDelay(Integer delay) {
            this.delay = delay;
        }

        public String getMasterBinlogFile() {
            return this.masterBinlogFile;
        }

        public void setMasterBinlogFile(String masterBinlogFile) {
            this.masterBinlogFile = masterBinlogFile;
        }

        public String getCurrentBinlogFile() {
            return this.currentBinlogFile;
        }

        public void setCurrentBinlogFile(String currentBinlogFile) {
            this.currentBinlogFile = currentBinlogFile;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getParentOuterProdInstId() {
            return this.parentOuterProdInstId;
        }

        public void setParentOuterProdInstId(String parentOuterProdInstId) {
            this.parentOuterProdInstId = parentOuterProdInstId;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    }
}
