package cn.ctyun.apis.instance;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询节点列表 */
public class Rds2QueryNodeInfosV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2QueryNodeInfosV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/query-node-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryNodeInfosV4Response send(Credential credential, QueryNodeInfosV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryNodeInfosV4Response.class);
    }

    public static class QueryNodeInfosV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class QueryNodeInfosV4Response {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 列表信息 */
        @JsonProperty("returnObj")
        private List<QueryNodeInfosV4ReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<QueryNodeInfosV4ReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<QueryNodeInfosV4ReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryNodeInfosV4ReturnObjResponse {
        /** 主机id */
        @JsonProperty("hostInstId")
        private String hostInstId;

        /** 主机ip */
        @JsonProperty("host")
        private String host;

        /** 子网名称 */
        @JsonProperty("subnetName")
        private String subnetName;

        /** 子网id */
        @JsonProperty("subnetId")
        private String subnetId;

        /** 节点角色 m:主 s:从 */
        @JsonProperty("role")
        private String role;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Long createTime;

        /** CPU核心数 */
        @JsonProperty("cpu")
        private String cpu;

        /** 磁盘类型 */
        @JsonProperty("diskType")
        private String diskType;

        /** 磁盘大小 */
        @JsonProperty("diskSpace")
        private String diskSpace;

        /** 内存大小 */
        @JsonProperty("memory")
        private String memory;

        public String getHostInstId() {
            return this.hostInstId;
        }

        public void setHostInstId(String hostInstId) {
            this.hostInstId = hostInstId;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getSubnetName() {
            return this.subnetName;
        }

        public void setSubnetName(String subnetName) {
            this.subnetName = subnetName;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public String getDiskType() {
            return this.diskType;
        }

        public void setDiskType(String diskType) {
            this.diskType = diskType;
        }

        public String getDiskSpace() {
            return this.diskSpace;
        }

        public void setDiskSpace(String diskSpace) {
            this.diskSpace = diskSpace;
        }

        public String getMemory() {
            return this.memory;
        }

        public void setMemory(String memory) {
            this.memory = memory;
        }
    }
}
