package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/**
 * 设置存储空间自动扩容
 */
public class Rds2ModifyAutoExpansionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ModifyAutoExpansionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/RDS2/v1/open-api/instance/auto-expansion",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request    请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifyAutoExpansionResponse send(
            Credential credential, ModifyAutoExpansionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyAutoExpansionResponse.class);
    }

    public static class ModifyAutoExpansionRequest {
        /**
         * 项目id
         */
        @JsonProperty("project-id")
        private String projectId;

        /**
         * 实例id （和参数outerProdInstId保持一致）
         */
        @JsonProperty("inst-id")
        private String instId;

        /**
         * 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /**
         * 开启状态，0-开启，1-关闭
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 扩容上限 正整数且小于最大上限（查询接口获取）
         */
        @JsonProperty("upperLimit")
        private String upperLimit;

        /**
         * 触发阈值（0.5-0.9）
         */
        @JsonProperty("threshold")
        private String threshold;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getUpperLimit() {
            return this.upperLimit;
        }

        public void setUpperLimit(String upperLimit) {
            this.upperLimit = upperLimit;
        }

        public String getThreshold() {
            return this.threshold;
        }

        public void setThreshold(String threshold) {
            this.threshold = threshold;
        }
    }

    public static class ModifyAutoExpansionResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /**
         * 返回信息
         */
        @JsonProperty("message")
        private String message;

        /**
         * 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空
         */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "ModifyAutoExpansionResponse{" +
                    "statusCode=" + statusCode +
                    ", message='" + message + '\'' +
                    ", error='" + error + '\'' +
                    '}';
        }
    }
}
