package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/**
 * 查询实例是否支持在线扩盘
 */
public class Rds2GetOnlineResizeDiskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetOnlineResizeDiskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/instance/online-resize-disk", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request    请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetOnlineResizeDiskResponse send(
            Credential credential, GetOnlineResizeDiskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetOnlineResizeDiskResponse.class);
    }

    public static class GetOnlineResizeDiskRequest {
        /**
         * 项目id
         */
        @JsonProperty("project-id")
        private String projectId;

        /**
         * 实例id （和参数outerProdInstId保持一致）
         */
        @JsonProperty("inst-id")
        private String instId;

        /**
         * 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetOnlineResizeDiskResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /**
         * 返回对象
         */
        @JsonProperty("returnObj")
        private GetOnlineResizeDiskReturnObjResponse returnObj;

        /**
         * 返回信息
         */
        @JsonProperty("message")
        private String message;

        /**
         * 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空
         */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public GetOnlineResizeDiskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(
                GetOnlineResizeDiskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "GetOnlineResizeDiskResponse{" +
                    "statusCode=" + statusCode +
                    ", returnObj=" + returnObj +
                    ", message='" + message + '\'' +
                    ", error='" + error + '\'' +
                    '}';
        }
    }

    public static class GetOnlineResizeDiskReturnObjResponse {
        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /**
         * 是否支持在线扩容
         */
        @JsonProperty("supportOnlineResizeDisk")
        private Boolean supportOnlineResizeDisk;

        /**
         * 支持最大扩容上限 单位GB
         */
        @JsonProperty("maxSupportDisk")
        private Integer maxSupportDisk;

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Boolean getSupportOnlineResizeDisk() {
            return this.supportOnlineResizeDisk;
        }

        public void setSupportOnlineResizeDisk(Boolean supportOnlineResizeDisk) {
            this.supportOnlineResizeDisk = supportOnlineResizeDisk;
        }

        public Integer getMaxSupportDisk() {
            return this.maxSupportDisk;
        }

        public void setMaxSupportDisk(Integer maxSupportDisk) {
            this.maxSupportDisk = maxSupportDisk;
        }

        @Override
        public String toString() {
            return "GetOnlineResizeDiskReturnObjResponse{" +
                    "outerProdInstId='" + outerProdInstId + '\'' +
                    ", supportOnlineResizeDisk=" + supportOnlineResizeDisk +
                    ", maxSupportDisk=" + maxSupportDisk +
                    '}';
        }
    }
}
