package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 调用接口查询实例所有连接信息 */
public class Rds2GetInstanceNetInfoV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstanceNetInfoV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/instance-net-info",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceNetInfoV4Response send(
            Credential credential, GetInstanceNetInfoV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceNetInfoV4Response.class);
    }

    public static class GetInstanceNetInfoV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetInstanceNetInfoV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetInstanceNetInfoV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceNetInfoV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceNetInfoV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetInstanceNetInfoV4ReturnObjResponse {
        /** 数据库链接地址 */
        @JsonProperty("vip")
        private String vip;

        /** 数据库链接地址Ipv6 */
        @JsonProperty("vip6")
        private String vip6;

        /** 读端口 */
        @JsonProperty("readPort")
        private String readPort;

        /** 写端口 */
        @JsonProperty("writePort")
        private String writePort;

        /** vpcId */
        @JsonProperty("vpcId")
        private String vpcId;

        /** 子网名称 */
        @JsonProperty("subnet")
        private String subnet;

        /** 实例名称 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        /** 子网id */
        @JsonProperty("subnetId")
        private String subnetId;

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public String getVip6() {
            return this.vip6;
        }

        public void setVip6(String vip6) {
            this.vip6 = vip6;
        }

        public String getReadPort() {
            return this.readPort;
        }

        public void setReadPort(String readPort) {
            this.readPort = readPort;
        }

        public String getWritePort() {
            return this.writePort;
        }

        public void setWritePort(String writePort) {
            this.writePort = writePort;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }
    }
}
