package cn.ctyun.apis.instance;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询实例列表 */
public class Rds2GetInstanceListV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstanceListV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/instance/instance-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceListV4Response send(Credential credential, GetInstanceListV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceListV4Response.class);
    }

    public static class GetInstanceListV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 单页记录条数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 标签列表 */
        @JsonProperty("tagVOList")
        private List<GetInstanceListV4TagVOListRequest> tagVOList;

        /** 数据库引擎 枚举 "5.7" "8.0" */
        @JsonProperty("resDbEngine")
        private String resDbEngine;

        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 连接ip */
        @JsonProperty("vip")
        private String vip;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public List<GetInstanceListV4TagVOListRequest> getTagVOList() {
            return this.tagVOList;
        }

        public void setTagVOList(List<GetInstanceListV4TagVOListRequest> tagVOList) {
            this.tagVOList = tagVOList;
        }

        public String getResDbEngine() {
            return this.resDbEngine;
        }

        public void setResDbEngine(String resDbEngine) {
            this.resDbEngine = resDbEngine;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }
    }

    public static class GetInstanceListV4TagVOListRequest {
        /** 标签value */
        @JsonProperty("value")
        private String value;

        /** 标签key */
        @JsonProperty("key")
        private String key;

        /** k-v的唯一标识,位于IT那边 */
        @JsonProperty("labelId")
        private String labelId;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public void setLabelId(String labelId) {
            this.labelId = labelId;
        }
    }

    public static class GetInstanceListV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 分页信息 */
        @JsonProperty("returnObj")
        private GetInstanceListV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceListV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceListV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetInstanceListV4ReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Integer navigatePages;

        /** 结果集(每页显示的数据) */
        @JsonProperty("list")
        private List<GetInstanceListV4ReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Integer getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Integer navigatePages) {
            this.navigatePages = navigatePages;
        }

        public List<GetInstanceListV4ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetInstanceListV4ReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class GetInstanceListV4ReturnObjListResponse {
        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 计费模式 0:按月计费,1:按天计费,2:按年计费,3:按流量计费 4按需计费 */
        @JsonProperty("prodBillType")
        private Integer prodBillType;

        /** 0:单机,1:一主一从,2:一主两从,4:只读实例 */
        @JsonProperty("prodType")
        private Integer prodType;

        /**
         * 0.正常 1.重启中 2.备份中 3.恢复中 4.修改参数中 5.应用参数组中 6.扩容预处理中 7.扩容预处理完成 8.修改端口中 9.迁移中 10.重置密码中
         * 11.修改数据复制方式中 12.缩容预处理中 13.缩容预处理完成 15.内核小版本升级 17.迁移可用区中 18.修改备份配置中 20.停止中 21.已停止 22.启动中
         * 26.白名单配置中
         */
        @JsonProperty("prodRunningStatus")
        private Integer prodRunningStatus;

        /**
         * 0.正常 1.欠费暂停 2.已注销 3.创建中 4.施工失败 5.到期退订状态 6.新增的状态-openApi暂停 7.创建完成等待变更单 8.待注销 9.手动暂停
         * 10.手动退订
         */
        @JsonProperty("prodOrderStatus")
        private Integer prodOrderStatus;

        /** 运行状态 0正常 -1异常 */
        @JsonProperty("alive")
        private Integer alive;

        /** 虚拟IP地址 */
        @JsonProperty("vip")
        private String vip;

        /** 虚拟IPv6地址 */
        @JsonProperty("vip6")
        private String vip6;

        /** 写数据端口 */
        @JsonProperty("writePort")
        private String writePort;

        /** 读端口 */
        @JsonProperty("readPort")
        private String readPort;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Long createTime;

        /** 到期时间 */
        @JsonProperty("expireTime")
        private Long expireTime;

        /** 实例规格 */
        @JsonProperty("machineSpec")
        private String machineSpec;

        /** 数据库引擎 */
        @JsonProperty("prodDbEngine")
        private String prodDbEngine;

        /** 存储空间大小 单位G */
        @JsonProperty("diskSize")
        private Integer diskSize;

        /** mysql版本 */
        @JsonProperty("newMysqlVersion")
        private String newMysqlVersion;

        /** 存储类型：1.SATA 2.SAS 3.SSD 4.LVM */
        @JsonProperty("diskType")
        private String diskType;

        /** 备份空间使用率 */
        @JsonProperty("backupDiskUsedRated")
        private Integer backupDiskUsedRated;

        /** 虚拟私有云 */
        @JsonProperty("netName")
        private String netName;

        /** 子网名 */
        @JsonProperty("subnet")
        private String subnet;

        /** 实例标签 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        /** 订单ld */
        @JsonProperty("orderId")
        private Long orderId;

        /** 是否可升级 */
        @JsonProperty("canOperate")
        private Integer canOperate;

        /** 实例模板名 */
        @JsonProperty("tplName")
        private String tplName;

        /** 日志审计开关 */
        @JsonProperty("auditLogStatus")
        private Integer auditLogStatus;

        /** 参数模板名 */
        @JsonProperty("parameterGroupUsed")
        private String parameterGroupUsed;

        /** 虚拟私有云id */
        @JsonProperty("vpcId")
        private String vpcId;

        /** 是否使用对象存储 */
        @JsonProperty("usezos")
        private Integer usezos;

        /** 内部实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** mysql版本 */
        @JsonProperty("dbMysqlVersion")
        private String dbMysqlVersion;

        /** 订单来源 */
        @JsonProperty("resources")
        private String resources;

        /** 用户id */
        @JsonProperty("userId")
        private Integer userId;

        /** 计费模式 类型 */
        @JsonProperty("prodBillTime")
        private Integer prodBillTime;

        /** 租户id */
        @JsonProperty("tenantId")
        private String tenantId;

        /** 实例模板code */
        @JsonProperty("tplCode")
        private String tplCode;

        /** 产品id */
        @JsonProperty("prodId")
        private Integer prodId;

        /** 实例set名称 */
        @JsonProperty("prodInstSetName")
        private String prodInstSetName;

        /** 安全组名 */
        @JsonProperty("securityGroup")
        private String securityGroup;

        /** 项目id（可通过接口/teledb-dcp/v2/openapi/dcp-order-info/project/list查询所有项目id） */
        @JsonProperty("projectId")
        private String projectId;

        /** 项目名 */
        @JsonProperty("projectName")
        private String projectName;

        /** 是否允许暂停 */
        @JsonProperty("pauseEnable")
        private Boolean pauseEnable;

        /** 实例释放保护开关 1:on,0:off */
        @JsonProperty("instReleaseProtectionStatus")
        private Integer instReleaseProtectionStatus;

        /** 最后系统全备id */
        @JsonProperty("lastManualBackUp")
        private Integer lastManualBackUp;

        /** 是否允许续订 */
        @JsonProperty("renewalEnable")
        private Boolean renewalEnable;

        /** 1：mgr实例 0：非mgr实例 */
        @JsonProperty("isMGR")
        private Integer isMGR;

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getProdBillType() {
            return this.prodBillType;
        }

        public void setProdBillType(Integer prodBillType) {
            this.prodBillType = prodBillType;
        }

        public Integer getProdType() {
            return this.prodType;
        }

        public void setProdType(Integer prodType) {
            this.prodType = prodType;
        }

        public Integer getProdRunningStatus() {
            return this.prodRunningStatus;
        }

        public void setProdRunningStatus(Integer prodRunningStatus) {
            this.prodRunningStatus = prodRunningStatus;
        }

        public Integer getProdOrderStatus() {
            return this.prodOrderStatus;
        }

        public void setProdOrderStatus(Integer prodOrderStatus) {
            this.prodOrderStatus = prodOrderStatus;
        }

        public Integer getAlive() {
            return this.alive;
        }

        public void setAlive(Integer alive) {
            this.alive = alive;
        }

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public String getVip6() {
            return this.vip6;
        }

        public void setVip6(String vip6) {
            this.vip6 = vip6;
        }

        public String getWritePort() {
            return this.writePort;
        }

        public void setWritePort(String writePort) {
            this.writePort = writePort;
        }

        public String getReadPort() {
            return this.readPort;
        }

        public void setReadPort(String readPort) {
            this.readPort = readPort;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(Long expireTime) {
            this.expireTime = expireTime;
        }

        public String getMachineSpec() {
            return this.machineSpec;
        }

        public void setMachineSpec(String machineSpec) {
            this.machineSpec = machineSpec;
        }

        public String getProdDbEngine() {
            return this.prodDbEngine;
        }

        public void setProdDbEngine(String prodDbEngine) {
            this.prodDbEngine = prodDbEngine;
        }

        public Integer getDiskSize() {
            return this.diskSize;
        }

        public void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        public String getNewMysqlVersion() {
            return this.newMysqlVersion;
        }

        public void setNewMysqlVersion(String newMysqlVersion) {
            this.newMysqlVersion = newMysqlVersion;
        }

        public String getDiskType() {
            return this.diskType;
        }

        public void setDiskType(String diskType) {
            this.diskType = diskType;
        }

        public Integer getBackupDiskUsedRated() {
            return this.backupDiskUsedRated;
        }

        public void setBackupDiskUsedRated(Integer backupDiskUsedRated) {
            this.backupDiskUsedRated = backupDiskUsedRated;
        }

        public String getNetName() {
            return this.netName;
        }

        public void setNetName(String netName) {
            this.netName = netName;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }

        public Long getOrderId() {
            return this.orderId;
        }

        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        public Integer getCanOperate() {
            return this.canOperate;
        }

        public void setCanOperate(Integer canOperate) {
            this.canOperate = canOperate;
        }

        public String getTplName() {
            return this.tplName;
        }

        public void setTplName(String tplName) {
            this.tplName = tplName;
        }

        public Integer getAuditLogStatus() {
            return this.auditLogStatus;
        }

        public void setAuditLogStatus(Integer auditLogStatus) {
            this.auditLogStatus = auditLogStatus;
        }

        public String getParameterGroupUsed() {
            return this.parameterGroupUsed;
        }

        public void setParameterGroupUsed(String parameterGroupUsed) {
            this.parameterGroupUsed = parameterGroupUsed;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public Integer getUsezos() {
            return this.usezos;
        }

        public void setUsezos(Integer usezos) {
            this.usezos = usezos;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getDbMysqlVersion() {
            return this.dbMysqlVersion;
        }

        public void setDbMysqlVersion(String dbMysqlVersion) {
            this.dbMysqlVersion = dbMysqlVersion;
        }

        public String getResources() {
            return this.resources;
        }

        public void setResources(String resources) {
            this.resources = resources;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public Integer getProdBillTime() {
            return this.prodBillTime;
        }

        public void setProdBillTime(Integer prodBillTime) {
            this.prodBillTime = prodBillTime;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTplCode() {
            return this.tplCode;
        }

        public void setTplCode(String tplCode) {
            this.tplCode = tplCode;
        }

        public Integer getProdId() {
            return this.prodId;
        }

        public void setProdId(Integer prodId) {
            this.prodId = prodId;
        }

        public String getProdInstSetName() {
            return this.prodInstSetName;
        }

        public void setProdInstSetName(String prodInstSetName) {
            this.prodInstSetName = prodInstSetName;
        }

        public String getSecurityGroup() {
            return this.securityGroup;
        }

        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public Boolean getPauseEnable() {
            return this.pauseEnable;
        }

        public void setPauseEnable(Boolean pauseEnable) {
            this.pauseEnable = pauseEnable;
        }

        public Integer getInstReleaseProtectionStatus() {
            return this.instReleaseProtectionStatus;
        }

        public void setInstReleaseProtectionStatus(Integer instReleaseProtectionStatus) {
            this.instReleaseProtectionStatus = instReleaseProtectionStatus;
        }

        public Integer getLastManualBackUp() {
            return this.lastManualBackUp;
        }

        public void setLastManualBackUp(Integer lastManualBackUp) {
            this.lastManualBackUp = lastManualBackUp;
        }

        public Boolean getRenewalEnable() {
            return this.renewalEnable;
        }

        public void setRenewalEnable(Boolean renewalEnable) {
            this.renewalEnable = renewalEnable;
        }

        public Integer getIsMGR() {
            return this.isMGR;
        }

        public void setIsMGR(Integer isMGR) {
            this.isMGR = isMGR;
        }
    }
}
