package cn.ctyun.apis.instance;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据数据库实例ID查询该实例基本实例详情。 */
public class Rds2GetInstanceDetailV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstanceDetailV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/instance", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceDetailV4Response send(
            Credential credential, GetInstanceDetailV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceDetailV4Response.class);
    }

    public static class GetInstanceDetailV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetInstanceDetailV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetInstanceDetailV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceDetailV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceDetailV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetInstanceDetailV4ReturnObjResponse {
        /** 计费模式 0:按月计费,1:按天计费,2:按年计费,3:按流量计费 4按需计费 */
        @JsonProperty("prodBillType")
        private Integer prodBillType;

        /** 0单机 1：1M1S 2:1M2S 3:1M3S */
        @JsonProperty("prodType")
        private Integer prodType;

        /** 0.正常 1.重启中 2.备份中 3.恢复中 4.修改参数中 5.应用参数组中 6&7.扩容中 8.修改端口中 9.迁移中 10.重置密码中 */
        @JsonProperty("prodRunningStatus")
        private Integer prodRunningStatus;

        /** 0.正常 1.已暂停 2.已注销 3.创建中 */
        @JsonProperty("prodOrderStatus")
        private Integer prodOrderStatus;

        /** 运行状态 0正常 -1异常 */
        @JsonProperty("alive")
        private Integer alive;

        /** 虚拟IP地址 */
        @JsonProperty("vip")
        private String vip;

        /** 虚拟IP v6地址 */
        @JsonProperty("vip6")
        private String vip6;

        /** 写数据端口 */
        @JsonProperty("writePort")
        private String writePort;

        /** 读端口 */
        @JsonProperty("readPort")
        private String readPort;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Long createTime;

        /** 到期时间 */
        @JsonProperty("expireTime")
        private Long expireTime;

        /** 实例规格 */
        @JsonProperty("machineSpec")
        private String machineSpec;

        /** 数据库引擎 */
        @JsonProperty("prodDbEngine")
        private String prodDbEngine;

        /** 存储空间大小 单位G */
        @JsonProperty("diskTotal")
        private String diskTotal;

        /** 磁盘使用率% */
        @JsonProperty("diskRated")
        private Integer diskRated;

        /** 存储类型：1SATA2SAS 3-SSD 4-LVM */
        @JsonProperty("diskType")
        private String diskType;

        /** 磁盘大小单位G */
        @JsonProperty("diskSize")
        private Integer diskSize;

        /** 备份空间使用率 */
        @JsonProperty("backupDiskUsedRated")
        private Integer backupDiskUsedRated;

        /** 备份空间已经使用大小（单位G） */
        @JsonProperty("backupUsedDiskSize")
        private Float backupUsedDiskSize;

        /**
         * 备份空间类型： * 0: 没有设置备份 * 1: 主机挂盘备份 （展示备份空间使用信息：大小和比例） * 2： 对象存储（不展示备份空间信息） * 3：
         * 只读实例（不展示备份空间信息）
         */
        @JsonProperty("backupStoreType")
        private Integer backupStoreType;

        /** 实例集群名称 */
        @JsonProperty("prodInstSetName")
        private String prodInstSetName;

        /** 虚拟私有云 */
        @JsonProperty("netName")
        private String netName;

        /** 弹性ip */
        @JsonProperty("eIP")
        private String eIP;

        /** 弹性ip状态 0->unbind，1->bind,2->binding */
        @JsonProperty("eipStatus")
        private Integer eipStatus;

        /** 子网名 */
        @JsonProperty("subnet")
        private String subnet;

        /** Ssl状态 0->off，1->on */
        @JsonProperty("sslStatus")
        private Integer sslStatus;

        /** 可用区信息 */
        @JsonProperty("azInfoList")
        private List<GetInstanceDetailV4ReturnObjAzInfoListResponse> azInfoList;

        /** mysql版本 */
        @JsonProperty("newMysqlVersion")
        private String newMysqlVersion;

        /** 子网id */
        @JsonProperty("subnetId")
        private String subnetId;

        /** 订单id */
        @JsonProperty("orderId")
        private Long orderId;

        /** 安全组id */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** 实例模板名 */
        @JsonProperty("tplName")
        private String tplName;

        /** 日志审计开关 */
        @JsonProperty("auditLogStatus")
        private Integer auditLogStatus;

        /** 安全组名 */
        @JsonProperty("securityGroup")
        private String securityGroup;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 内部实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 实例标签 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        /** 磁盘使用率（取整前） */
        @JsonProperty("diskUsed")
        private String diskUsed;

        /** 参数模板名 */
        @JsonProperty("parameterGroupUsed")
        private String parameterGroupUsed;

        /** 虚拟私有云id */
        @JsonProperty("vpcId")
        private String vpcId;

        /** 是否使用对象存储 */
        @JsonProperty("usezos")
        private Integer usezos;

        /** 实例名 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 产品id */
        @JsonProperty("prodId")
        private Integer prodId;

        /** 订单来源 */
        @JsonProperty("resources")
        private String resources;

        /** 用户id */
        @JsonProperty("userId")
        private Integer userId;

        /** 计费模式 类型 */
        @JsonProperty("prodBillTime")
        private Integer prodBillTime;

        /** 租户id */
        @JsonProperty("tenantId")
        private String tenantId;

        /** 备份空间大小 单位G */
        @JsonProperty("backupDiskSize")
        private Integer backupDiskSize;

        /** 实例模板code */
        @JsonProperty("tplCode")
        private String tplCode;

        /** mysql版本 */
        @JsonProperty("dbMysqlVersion")
        private String dbMysqlVersion;

        /** 项目id（可通过接口/teledb-dcp/v2/openapi/dcp-order-info/project/list查询所有项目id） */
        @JsonProperty("projectId")
        private String projectId;

        /** 项目名 */
        @JsonProperty("projectName")
        private String projectName;

        /** data文件已使用的存储大小 */
        @JsonProperty("diskDataUsed")
        private String diskDataUsed;

        /** 是否允许暂停 */
        @JsonProperty("pauseEnable")
        private Boolean pauseEnable;

        /** 大小写配置 */
        @JsonProperty("lowerCaseTableNames")
        private Integer lowerCaseTableNames;

        /** 实例释放保护开关 1:on,0:off */
        @JsonProperty("instReleaseProtectionStatus")
        private Integer instReleaseProtectionStatus;

        /** 数据库端口 */
        @JsonProperty("mysqlPort")
        private String mysqlPort;

        /** binlog文件已使用的存储大小 */
        @JsonProperty("diskLogUsed")
        private String diskLogUsed;

        /** data文件已使用的存储使用率 */
        @JsonProperty("diskDataUsedRated")
        private Integer diskDataUsedRated;

        /** 时区 */
        @JsonProperty("timezone")
        private String timezone;

        /** 最后系统全备id */
        @JsonProperty("lastManualBackUp")
        private Integer lastManualBackUp;

        /** 主机系列 */
        @JsonProperty("hostSeries")
        private String hostSeries;

        /** 安全组状态 0->normal, 1->changing, 2->deleted */
        @JsonProperty("securityGroupStatus")
        private Integer securityGroupStatus;

        /** 是否允许续订 */
        @JsonProperty("renewalEnable")
        private Boolean renewalEnable;

        /** 1：mgr实例 0：非mgr实例 */
        @JsonProperty("isMGR")
        private Integer isMGR;

        /** binlog文件已使用的存储使用率 */
        @JsonProperty("diskLogUsedRated")
        private Integer diskLogUsedRated;

        /** 备份使用大小，单位G */
        @JsonProperty("usedBackupSize")
        private Float usedBackupSize;

        /** binlog备份文件大小，单位G */
        @JsonProperty("backupBinlogSize")
        private Float backupBinlogSize;

        /** 物理备份文件大小，单位G */
        @JsonProperty("backupDataSize")
        private Float backupDataSize;

        /** 实例绑定的安全组列表 */
        @JsonProperty("securityGroupList")
        private List<GetInstanceDetailV4ReturnObjSecurityGroupListResponse> securityGroupList;

        public Integer getProdBillType() {
            return this.prodBillType;
        }

        public void setProdBillType(Integer prodBillType) {
            this.prodBillType = prodBillType;
        }

        public Integer getProdType() {
            return this.prodType;
        }

        public void setProdType(Integer prodType) {
            this.prodType = prodType;
        }

        public Integer getProdRunningStatus() {
            return this.prodRunningStatus;
        }

        public void setProdRunningStatus(Integer prodRunningStatus) {
            this.prodRunningStatus = prodRunningStatus;
        }

        public Integer getProdOrderStatus() {
            return this.prodOrderStatus;
        }

        public void setProdOrderStatus(Integer prodOrderStatus) {
            this.prodOrderStatus = prodOrderStatus;
        }

        public Integer getAlive() {
            return this.alive;
        }

        public void setAlive(Integer alive) {
            this.alive = alive;
        }

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public String getVip6() {
            return this.vip6;
        }

        public void setVip6(String vip6) {
            this.vip6 = vip6;
        }

        public String getWritePort() {
            return this.writePort;
        }

        public void setWritePort(String writePort) {
            this.writePort = writePort;
        }

        public String getReadPort() {
            return this.readPort;
        }

        public void setReadPort(String readPort) {
            this.readPort = readPort;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(Long expireTime) {
            this.expireTime = expireTime;
        }

        public String getMachineSpec() {
            return this.machineSpec;
        }

        public void setMachineSpec(String machineSpec) {
            this.machineSpec = machineSpec;
        }

        public String getProdDbEngine() {
            return this.prodDbEngine;
        }

        public void setProdDbEngine(String prodDbEngine) {
            this.prodDbEngine = prodDbEngine;
        }

        public String getDiskTotal() {
            return this.diskTotal;
        }

        public void setDiskTotal(String diskTotal) {
            this.diskTotal = diskTotal;
        }

        public Integer getDiskRated() {
            return this.diskRated;
        }

        public void setDiskRated(Integer diskRated) {
            this.diskRated = diskRated;
        }

        public String getDiskType() {
            return this.diskType;
        }

        public void setDiskType(String diskType) {
            this.diskType = diskType;
        }

        public Integer getDiskSize() {
            return this.diskSize;
        }

        public void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        public Integer getBackupDiskUsedRated() {
            return this.backupDiskUsedRated;
        }

        public void setBackupDiskUsedRated(Integer backupDiskUsedRated) {
            this.backupDiskUsedRated = backupDiskUsedRated;
        }

        public Float getBackupUsedDiskSize() {
            return this.backupUsedDiskSize;
        }

        public void setBackupUsedDiskSize(Float backupUsedDiskSize) {
            this.backupUsedDiskSize = backupUsedDiskSize;
        }

        public Integer getBackupStoreType() {
            return this.backupStoreType;
        }

        public void setBackupStoreType(Integer backupStoreType) {
            this.backupStoreType = backupStoreType;
        }

        public String getProdInstSetName() {
            return this.prodInstSetName;
        }

        public void setProdInstSetName(String prodInstSetName) {
            this.prodInstSetName = prodInstSetName;
        }

        public String getNetName() {
            return this.netName;
        }

        public void setNetName(String netName) {
            this.netName = netName;
        }

        public String getEIP() {
            return this.eIP;
        }

        public void setEIP(String eIP) {
            this.eIP = eIP;
        }

        public Integer getEipStatus() {
            return this.eipStatus;
        }

        public void setEipStatus(Integer eipStatus) {
            this.eipStatus = eipStatus;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        public Integer getSslStatus() {
            return this.sslStatus;
        }

        public void setSslStatus(Integer sslStatus) {
            this.sslStatus = sslStatus;
        }

        public List<GetInstanceDetailV4ReturnObjAzInfoListResponse> getAzInfoList() {
            return this.azInfoList;
        }

        public void setAzInfoList(List<GetInstanceDetailV4ReturnObjAzInfoListResponse> azInfoList) {
            this.azInfoList = azInfoList;
        }

        public String getNewMysqlVersion() {
            return this.newMysqlVersion;
        }

        public void setNewMysqlVersion(String newMysqlVersion) {
            this.newMysqlVersion = newMysqlVersion;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public Long getOrderId() {
            return this.orderId;
        }

        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getTplName() {
            return this.tplName;
        }

        public void setTplName(String tplName) {
            this.tplName = tplName;
        }

        public Integer getAuditLogStatus() {
            return this.auditLogStatus;
        }

        public void setAuditLogStatus(Integer auditLogStatus) {
            this.auditLogStatus = auditLogStatus;
        }

        public String getSecurityGroup() {
            return this.securityGroup;
        }

        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }

        public String getDiskUsed() {
            return this.diskUsed;
        }

        public void setDiskUsed(String diskUsed) {
            this.diskUsed = diskUsed;
        }

        public String getParameterGroupUsed() {
            return this.parameterGroupUsed;
        }

        public void setParameterGroupUsed(String parameterGroupUsed) {
            this.parameterGroupUsed = parameterGroupUsed;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public Integer getUsezos() {
            return this.usezos;
        }

        public void setUsezos(Integer usezos) {
            this.usezos = usezos;
        }

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public Integer getProdId() {
            return this.prodId;
        }

        public void setProdId(Integer prodId) {
            this.prodId = prodId;
        }

        public String getResources() {
            return this.resources;
        }

        public void setResources(String resources) {
            this.resources = resources;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public Integer getProdBillTime() {
            return this.prodBillTime;
        }

        public void setProdBillTime(Integer prodBillTime) {
            this.prodBillTime = prodBillTime;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public Integer getBackupDiskSize() {
            return this.backupDiskSize;
        }

        public void setBackupDiskSize(Integer backupDiskSize) {
            this.backupDiskSize = backupDiskSize;
        }

        public String getTplCode() {
            return this.tplCode;
        }

        public void setTplCode(String tplCode) {
            this.tplCode = tplCode;
        }

        public String getDbMysqlVersion() {
            return this.dbMysqlVersion;
        }

        public void setDbMysqlVersion(String dbMysqlVersion) {
            this.dbMysqlVersion = dbMysqlVersion;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public String getDiskDataUsed() {
            return this.diskDataUsed;
        }

        public void setDiskDataUsed(String diskDataUsed) {
            this.diskDataUsed = diskDataUsed;
        }

        public Boolean getPauseEnable() {
            return this.pauseEnable;
        }

        public void setPauseEnable(Boolean pauseEnable) {
            this.pauseEnable = pauseEnable;
        }

        public Integer getLowerCaseTableNames() {
            return this.lowerCaseTableNames;
        }

        public void setLowerCaseTableNames(Integer lowerCaseTableNames) {
            this.lowerCaseTableNames = lowerCaseTableNames;
        }

        public Integer getInstReleaseProtectionStatus() {
            return this.instReleaseProtectionStatus;
        }

        public void setInstReleaseProtectionStatus(Integer instReleaseProtectionStatus) {
            this.instReleaseProtectionStatus = instReleaseProtectionStatus;
        }

        public String getMysqlPort() {
            return this.mysqlPort;
        }

        public void setMysqlPort(String mysqlPort) {
            this.mysqlPort = mysqlPort;
        }

        public String getDiskLogUsed() {
            return this.diskLogUsed;
        }

        public void setDiskLogUsed(String diskLogUsed) {
            this.diskLogUsed = diskLogUsed;
        }

        public Integer getDiskDataUsedRated() {
            return this.diskDataUsedRated;
        }

        public void setDiskDataUsedRated(Integer diskDataUsedRated) {
            this.diskDataUsedRated = diskDataUsedRated;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public Integer getLastManualBackUp() {
            return this.lastManualBackUp;
        }

        public void setLastManualBackUp(Integer lastManualBackUp) {
            this.lastManualBackUp = lastManualBackUp;
        }

        public String getHostSeries() {
            return this.hostSeries;
        }

        public void setHostSeries(String hostSeries) {
            this.hostSeries = hostSeries;
        }

        public Integer getSecurityGroupStatus() {
            return this.securityGroupStatus;
        }

        public void setSecurityGroupStatus(Integer securityGroupStatus) {
            this.securityGroupStatus = securityGroupStatus;
        }

        public Boolean getRenewalEnable() {
            return this.renewalEnable;
        }

        public void setRenewalEnable(Boolean renewalEnable) {
            this.renewalEnable = renewalEnable;
        }

        public Integer getIsMGR() {
            return this.isMGR;
        }

        public void setIsMGR(Integer isMGR) {
            this.isMGR = isMGR;
        }

        public Integer getDiskLogUsedRated() {
            return this.diskLogUsedRated;
        }

        public void setDiskLogUsedRated(Integer diskLogUsedRated) {
            this.diskLogUsedRated = diskLogUsedRated;
        }

        public Float getUsedBackupSize() {
            return this.usedBackupSize;
        }

        public void setUsedBackupSize(Float usedBackupSize) {
            this.usedBackupSize = usedBackupSize;
        }

        public Float getBackupBinlogSize() {
            return this.backupBinlogSize;
        }

        public void setBackupBinlogSize(Float backupBinlogSize) {
            this.backupBinlogSize = backupBinlogSize;
        }

        public Float getBackupDataSize() {
            return this.backupDataSize;
        }

        public void setBackupDataSize(Float backupDataSize) {
            this.backupDataSize = backupDataSize;
        }

        public List<GetInstanceDetailV4ReturnObjSecurityGroupListResponse> getSecurityGroupList() {
            return this.securityGroupList;
        }

        public void setSecurityGroupList(
                List<GetInstanceDetailV4ReturnObjSecurityGroupListResponse> securityGroupList) {
            this.securityGroupList = securityGroupList;
        }
    }

    public static class GetInstanceDetailV4ReturnObjAzInfoListResponse {
        /** 资源id */
        @JsonProperty("resId")
        private Integer resId;

        /** 实例角色 */
        @JsonProperty("role")
        private String role;

        /** AZ名称 */
        @JsonProperty("azName")
        private String azName;

        /** azId */
        @JsonProperty("azId")
        private String azId;

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getAzId() {
            return this.azId;
        }

        public void setAzId(String azId) {
            this.azId = azId;
        }
    }

    public static class GetInstanceDetailV4ReturnObjSecurityGroupListResponse {
        /** 安全组id */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** 安全组名称 */
        @JsonProperty("securityGroupName")
        private String securityGroupName;

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }
    }
}
