package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 通过过期时间过期状态等参数查询实例列表 */
public class Rds2GetInstanceByTimeV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetInstanceByTimeV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/instance/instance-by-time",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetInstanceByTimeV4Response send(
            Credential credential, GetInstanceByTimeV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetInstanceByTimeV4Response.class);
    }

    public static class GetInstanceByTimeV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 单页记录条数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 标签列表 */
        @JsonProperty("tagVOList")
        private List<GetInstanceByTimeV4TagVOListRequest> tagVOList;

        /** 实例剩余可用天数。取值：0~180 少于指定天数的实例会被查出来 */
        @JsonProperty("expireDays")
        private Integer expireDays;

        /** 是否过期 */
        @JsonProperty("expire")
        private Boolean expire;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public List<GetInstanceByTimeV4TagVOListRequest> getTagVOList() {
            return this.tagVOList;
        }

        public void setTagVOList(List<GetInstanceByTimeV4TagVOListRequest> tagVOList) {
            this.tagVOList = tagVOList;
        }

        public Integer getExpireDays() {
            return this.expireDays;
        }

        public void setExpireDays(Integer expireDays) {
            this.expireDays = expireDays;
        }

        public Boolean getExpire() {
            return this.expire;
        }

        public void setExpire(Boolean expire) {
            this.expire = expire;
        }
    }

    public static class GetInstanceByTimeV4TagVOListRequest {
        /** 标签value */
        @JsonProperty("value")
        private String value;

        /** 标签key */
        @JsonProperty("key")
        private String key;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }

    public static class GetInstanceByTimeV4Response {
        /** 返回码取值范围：0 成功 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 分页信息 */
        @JsonProperty("returnObj")
        private GetInstanceByTimeV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetInstanceByTimeV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetInstanceByTimeV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetInstanceByTimeV4ReturnObjResponse {
        /** 当前页 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页的数量 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 当前页的数量 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页面第一个元素在数据库中的行号 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 当前页面最后一个元素在数据库中的行号 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 第一页 */
        @JsonProperty("firstPage")
        private Integer firstPage;

        /** 前一页 */
        @JsonProperty("prePage")
        private Integer prePage;

        /** 是否为第一页 */
        @JsonProperty("isFirstPage")
        private Boolean isFirstPage;

        /** 是否为最后一页 */
        @JsonProperty("isLastPage")
        private Boolean isLastPage;

        /** 是否有前一页 */
        @JsonProperty("hasPreviousPage")
        private Boolean hasPreviousPage;

        /** 是否有下一页 */
        @JsonProperty("hasNextPage")
        private Boolean hasNextPage;

        /** 导航页码数 */
        @JsonProperty("navigatePages")
        private Boolean navigatePages;

        /** 结果集(每页显示的数据） */
        @JsonProperty("list")
        private List<GetInstanceByTimeV4ReturnObjListResponse> list;

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getFirstPage() {
            return this.firstPage;
        }

        public void setFirstPage(Integer firstPage) {
            this.firstPage = firstPage;
        }

        public Integer getPrePage() {
            return this.prePage;
        }

        public void setPrePage(Integer prePage) {
            this.prePage = prePage;
        }

        public Boolean getIsFirstPage() {
            return this.isFirstPage;
        }

        public void setIsFirstPage(Boolean isFirstPage) {
            this.isFirstPage = isFirstPage;
        }

        public Boolean getIsLastPage() {
            return this.isLastPage;
        }

        public void setIsLastPage(Boolean isLastPage) {
            this.isLastPage = isLastPage;
        }

        public Boolean getHasPreviousPage() {
            return this.hasPreviousPage;
        }

        public void setHasPreviousPage(Boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
        }

        public Boolean getHasNextPage() {
            return this.hasNextPage;
        }

        public void setHasNextPage(Boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
        }

        public Boolean getNavigatePages() {
            return this.navigatePages;
        }

        public void setNavigatePages(Boolean navigatePages) {
            this.navigatePages = navigatePages;
        }

        public List<GetInstanceByTimeV4ReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<GetInstanceByTimeV4ReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class GetInstanceByTimeV4ReturnObjListResponse {
        /** 实例名称 */
        @JsonProperty("prodInstName")
        private String prodInstName;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 计费模式 0:按月计费,1:按天计费,2:按年计费,3:按流量计费 4按需计费 */
        @JsonProperty("prodBillType")
        private Integer prodBillType;

        /** 0单机 1：1M1S 2:1M2S 3:1M3S */
        @JsonProperty("prodType")
        private Integer prodType;

        /** 0.正常 1.重启中 2.备份中 3.恢复中 4.修改参数中 5.应用参数组中 6&7.扩容中 8.修改端口中 9.迁移中 10.重置密码中 */
        @JsonProperty("prodRunningStatus")
        private Integer prodRunningStatus;

        /** 0.正常 1.已暂停 2.已注销 3.创建中 */
        @JsonProperty("prodOrderStatus")
        private Integer prodOrderStatus;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Long createTime;

        /** 到期时间 */
        @JsonProperty("expireTime")
        private Long expireTime;

        /** 实例标签 */
        @JsonProperty("prodInstFlag")
        private String prodInstFlag;

        /** 子网名称 */
        @JsonProperty("subnet")
        private String subnet;

        /** 实例引擎版本 */
        @JsonProperty("prodDbEngine")
        private String prodDbEngine;

        /** 虚拟私有云 */
        @JsonProperty("netName")
        private String netName;

        /** 磁盘大小单位GB */
        @JsonProperty("diskSize")
        private Integer diskSize;

        /** 实例模板名 */
        @JsonProperty("tplName")
        private String tplName;

        /** 备份空间使用率 */
        @JsonProperty("backupDiskUsedRated")
        private Integer backupDiskUsedRated;

        /** 参数模板名 */
        @JsonProperty("parameterGroupUsed")
        private String parameterGroupUsed;

        /** 实例集群名 */
        @JsonProperty("prodInstSetName")
        private String prodInstSetName;

        /** 存储类型：1SATA2SAS 3-SSD 4-LVM */
        @JsonProperty("diskType")
        private String diskType;

        /** 实例规格 */
        @JsonProperty("machineSpec")
        private String machineSpec;

        /** 安全组名 */
        @JsonProperty("securityGroup")
        private String securityGroup;

        /** 内部实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 产品id */
        @JsonProperty("prodId")
        private Integer prodId;

        /** 订单来源 */
        @JsonProperty("resources")
        private String resources;

        /** 实例模板code */
        @JsonProperty("tplCode")
        private String tplCode;

        /** 计费模式 类型 */
        @JsonProperty("prodBillTime")
        private Integer prodBillTime;

        /** 是否允许暂停 */
        @JsonProperty("pauseEnable")
        private Boolean pauseEnable;

        /** 最后系统全备id */
        @JsonProperty("lastManualBackUp")
        private Integer lastManualBackUp;

        /** 是否允许续订 */
        @JsonProperty("renewalEnable")
        private Boolean renewalEnable;

        public String getProdInstName() {
            return this.prodInstName;
        }

        public void setProdInstName(String prodInstName) {
            this.prodInstName = prodInstName;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getProdBillType() {
            return this.prodBillType;
        }

        public void setProdBillType(Integer prodBillType) {
            this.prodBillType = prodBillType;
        }

        public Integer getProdType() {
            return this.prodType;
        }

        public void setProdType(Integer prodType) {
            this.prodType = prodType;
        }

        public Integer getProdRunningStatus() {
            return this.prodRunningStatus;
        }

        public void setProdRunningStatus(Integer prodRunningStatus) {
            this.prodRunningStatus = prodRunningStatus;
        }

        public Integer getProdOrderStatus() {
            return this.prodOrderStatus;
        }

        public void setProdOrderStatus(Integer prodOrderStatus) {
            this.prodOrderStatus = prodOrderStatus;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(Long expireTime) {
            this.expireTime = expireTime;
        }

        public String getProdInstFlag() {
            return this.prodInstFlag;
        }

        public void setProdInstFlag(String prodInstFlag) {
            this.prodInstFlag = prodInstFlag;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        public String getProdDbEngine() {
            return this.prodDbEngine;
        }

        public void setProdDbEngine(String prodDbEngine) {
            this.prodDbEngine = prodDbEngine;
        }

        public String getNetName() {
            return this.netName;
        }

        public void setNetName(String netName) {
            this.netName = netName;
        }

        public Integer getDiskSize() {
            return this.diskSize;
        }

        public void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        public String getTplName() {
            return this.tplName;
        }

        public void setTplName(String tplName) {
            this.tplName = tplName;
        }

        public Integer getBackupDiskUsedRated() {
            return this.backupDiskUsedRated;
        }

        public void setBackupDiskUsedRated(Integer backupDiskUsedRated) {
            this.backupDiskUsedRated = backupDiskUsedRated;
        }

        public String getParameterGroupUsed() {
            return this.parameterGroupUsed;
        }

        public void setParameterGroupUsed(String parameterGroupUsed) {
            this.parameterGroupUsed = parameterGroupUsed;
        }

        public String getProdInstSetName() {
            return this.prodInstSetName;
        }

        public void setProdInstSetName(String prodInstSetName) {
            this.prodInstSetName = prodInstSetName;
        }

        public String getDiskType() {
            return this.diskType;
        }

        public void setDiskType(String diskType) {
            this.diskType = diskType;
        }

        public String getMachineSpec() {
            return this.machineSpec;
        }

        public void setMachineSpec(String machineSpec) {
            this.machineSpec = machineSpec;
        }

        public String getSecurityGroup() {
            return this.securityGroup;
        }

        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getProdId() {
            return this.prodId;
        }

        public void setProdId(Integer prodId) {
            this.prodId = prodId;
        }

        public String getResources() {
            return this.resources;
        }

        public void setResources(String resources) {
            this.resources = resources;
        }

        public String getTplCode() {
            return this.tplCode;
        }

        public void setTplCode(String tplCode) {
            this.tplCode = tplCode;
        }

        public Integer getProdBillTime() {
            return this.prodBillTime;
        }

        public void setProdBillTime(Integer prodBillTime) {
            this.prodBillTime = prodBillTime;
        }

        public Boolean getPauseEnable() {
            return this.pauseEnable;
        }

        public void setPauseEnable(Boolean pauseEnable) {
            this.pauseEnable = pauseEnable;
        }

        public Integer getLastManualBackUp() {
            return this.lastManualBackUp;
        }

        public void setLastManualBackUp(Integer lastManualBackUp) {
            this.lastManualBackUp = lastManualBackUp;
        }

        public Boolean getRenewalEnable() {
            return this.renewalEnable;
        }

        public void setRenewalEnable(Boolean renewalEnable) {
            this.renewalEnable = renewalEnable;
        }
    }
}
