package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询可迁移的可用区 */
public class Rds2GetAvailabilityZoneListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetAvailabilityZoneListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/availability-zone",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetAvailabilityZoneListResponse send(
            Credential credential, GetAvailabilityZoneListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.changeConfig != null) {
            ctReq.addParam("changeConfig", request.changeConfig);
            request.changeConfig = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetAvailabilityZoneListResponse.class);
    }

    public static class GetAvailabilityZoneListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 标识是否查询可变更的配置，true会返回可变更的配置，false表示不返回变更的配置，默认为false */
        @JsonProperty("changeConfig")
        private String changeConfig;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getChangeConfig() {
            return this.changeConfig;
        }

        public void setChangeConfig(String changeConfig) {
            this.changeConfig = changeConfig;
        }
    }

    public static class GetAvailabilityZoneListResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 分页信息 */
        @JsonProperty("returnObj")
        private GetAvailabilityZoneListReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetAvailabilityZoneListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetAvailabilityZoneListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetAvailabilityZoneListReturnObjResponse {
        /** 可用区列表 */
        @JsonProperty("azInfoList")
        private List<GetAvailabilityZoneListReturnObjAzInfoListResponse> azInfoList;

        /** 变更规格列表，changeConfig=true才返回 */
        @JsonProperty("instSpecList")
        private List<GetAvailabilityZoneListReturnObjInstSpecListResponse> instSpecList;

        public List<GetAvailabilityZoneListReturnObjAzInfoListResponse> getAzInfoList() {
            return this.azInfoList;
        }

        public void setAzInfoList(
                List<GetAvailabilityZoneListReturnObjAzInfoListResponse> azInfoList) {
            this.azInfoList = azInfoList;
        }

        public List<GetAvailabilityZoneListReturnObjInstSpecListResponse> getInstSpecList() {
            return this.instSpecList;
        }

        public void setInstSpecList(
                List<GetAvailabilityZoneListReturnObjInstSpecListResponse> instSpecList) {
            this.instSpecList = instSpecList;
        }
    }

    public static class GetAvailabilityZoneListReturnObjAzInfoListResponse {
        /** 资源池可用区Id */
        @JsonProperty("availabilityZoneId")
        private String availabilityZoneId;

        /** 资源池可用区名称 */
        @JsonProperty("displayName")
        private String displayName;

        public String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class GetAvailabilityZoneListReturnObjInstSpecListResponse {
        /** 规格名称 */
        @JsonProperty("specName")
        private String specName;

        /** 主机世代完整名称 */
        @JsonProperty("hostGeneration")
        private String hostGeneration;

        /** 建议最大连接数 */
        @JsonProperty("connection")
        private Integer connection;

        public String getSpecName() {
            return this.specName;
        }

        public void setSpecName(String specName) {
            this.specName = specName;
        }

        public String getHostGeneration() {
            return this.hostGeneration;
        }

        public void setHostGeneration(String hostGeneration) {
            this.hostGeneration = hostGeneration;
        }

        public Integer getConnection() {
            return this.connection;
        }

        public void setConnection(Integer connection) {
            this.connection = connection;
        }
    }
}
