package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/**
 * 查询性能自动扩缩容信息
 */
public class Rds2GetAutomaticPerformanceScalingApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetAutomaticPerformanceScalingApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/cpu-auto-scaling",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request    请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetAutomaticPerformanceScalingResponse send(
            Credential credential, GetAutomaticPerformanceScalingRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.method != null) {
            ctReq.addParam("method", request.method);
            request.method = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetAutomaticPerformanceScalingResponse.class);
    }

    public static class GetAutomaticPerformanceScalingRequest {
        /**
         * 项目id
         */
        @JsonProperty("project-id")
        private String projectId;

        /**
         * 实例id （和参数outerProdInstId保持一致）
         */
        @JsonProperty("inst-id")
        private String instId;

        /**
         * 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /**
         * 操作（扩容 expand 或缩容 degrade）
         */
        @JsonProperty("method")
        private String method;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }
    }

    public static class GetAutomaticPerformanceScalingResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /**
         * 返回对象
         */
        @JsonProperty("returnObj")
        private GetAutomaticPerformanceScalingReturnObjResponse returnObj;

        /**
         * 返回信息
         */
        @JsonProperty("message")
        private String message;

        /**
         * 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空
         */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public GetAutomaticPerformanceScalingReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetAutomaticPerformanceScalingReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        @Override
        public String toString() {
            return "GetAutomaticPerformanceScalingResponse{" +
                    "statusCode=" + statusCode +
                    ", returnObj=" + returnObj +
                    ", message='" + message + '\'' +
                    ", error='" + error + '\'' +
                    '}';
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetAutomaticPerformanceScalingReturnObjResponse {
        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /**
         * 触发阈值 0.1~0.9(10%~90%)
         */
        @JsonProperty("triggerValue")
        private String triggerValue;

        /**
         * 扩容上限/缩容下限（返回如：2C4G）
         */
        @JsonProperty("triggerLimit")
        private String triggerLimit;

        /**
         * 开启状态（0-开启、1-关闭）
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 创建、修改时间
         */
        @JsonProperty("createTime")
        private Long createTime;

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getTriggerValue() {
            return this.triggerValue;
        }

        public void setTriggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
        }

        public String getTriggerLimit() {
            return this.triggerLimit;
        }

        public void setTriggerLimit(String triggerLimit) {
            this.triggerLimit = triggerLimit;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public String toString() {
            return "GetAutomaticPerformanceScalingReturnObjResponse{" +
                    "outerProdInstId='" + outerProdInstId + '\'' +
                    ", triggerValue='" + triggerValue + '\'' +
                    ", triggerLimit='" + triggerLimit + '\'' +
                    ", status=" + status +
                    ", createTime=" + createTime +
                    '}';
        }
    }
}
