package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/**
 * 查询存储空间自动扩容信息
 */
public class Rds2GetAutoExpansionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetAutoExpansionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/instance/auto-expansion", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request    请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetAutoExpansionResponse send(Credential credential, GetAutoExpansionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetAutoExpansionResponse.class);
    }

    public static class GetAutoExpansionRequest {
        /**
         * 项目id
         */
        @JsonProperty("project-id")
        private String projectId;

        /**
         * 实例id （和参数outerProdInstId保持一致）
         */
        @JsonProperty("inst-id")
        private String instId;

        /**
         * 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetAutoExpansionResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /**
         * 返回对象
         */
        @JsonProperty("returnObj")
        private GetAutoExpansionReturnObjResponse returnObj;

        /**
         * 返回信息
         */
        @JsonProperty("message")
        private String message;

        /**
         * 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空
         */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public GetAutoExpansionReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetAutoExpansionReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "GetAutoExpansionResponse{" +
                    "statusCode=" + statusCode +
                    ", returnObj=" + returnObj +
                    ", message='" + message + '\'' +
                    ", error='" + error + '\'' +
                    '}';
        }
    }

    public static class GetAutoExpansionReturnObjResponse {
        /**
         * 实例id
         */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /**
         * 触发阈值 单位1=100%
         */
        @JsonProperty("triggerValue")
        private String triggerValue;

        /**
         * 扩容上限（存储空间返回如：2048）
         */
        @JsonProperty("triggerLimit")
        private String triggerLimit;

        /**
         * 开启状态（0-开启、1-关闭）
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 创建、修改时间
         */
        @JsonProperty("createTime")
        private Long createTime;

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getTriggerValue() {
            return this.triggerValue;
        }

        public void setTriggerValue(String triggerValue) {
            this.triggerValue = triggerValue;
        }

        public String getTriggerLimit() {
            return this.triggerLimit;
        }

        public void setTriggerLimit(String triggerLimit) {
            this.triggerLimit = triggerLimit;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        @Override
        public String toString() {
            return "GetAutoExpansionReturnObjResponse{" +
                    "outerProdInstId='" + outerProdInstId + '\'' +
                    ", triggerValue='" + triggerValue + '\'' +
                    ", triggerLimit='" + triggerLimit + '\'' +
                    ", status=" + status +
                    ", createTime=" + createTime +
                    '}';
        }
    }
}
