package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询RDS实例主备自动切换设置 */
public class Rds2DescribeHASwitchConfigV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2DescribeHASwitchConfigV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/instance/describe-ha-switch-config",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeHASwitchConfigV4Response send(
            Credential credential, DescribeHASwitchConfigV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeHASwitchConfigV4Response.class);
    }

    public static class DescribeHASwitchConfigV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class DescribeHASwitchConfigV4Response {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DescribeHASwitchConfigV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeHASwitchConfigV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeHASwitchConfigV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeHASwitchConfigV4ReturnObjResponse {
        /** 自动切换设置，auto代表自动切换，manual代表手动切换 */
        @JsonProperty("switchConfig")
        private String switchConfig;

        public String getSwitchConfig() {
            return this.switchConfig;
        }

        public void setSwitchConfig(String switchConfig) {
            this.switchConfig = switchConfig;
        }
    }
}
