package cn.ctyun.apis.instance;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 迁移实例可用区 */
public class Rds2AzMigrationApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2AzMigrationApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/instance/migration-zone",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AzMigrationResponse send(Credential credential, AzMigrationRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AzMigrationResponse.class);
    }

    public static class AzMigrationRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源区regionId，比如实例在资源区A，则需要填写A资源区的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 标识是否在进行可用区迁移的时候变更配置，ture为变更配置，false为不变更配置，默认为false */
        @JsonProperty("changeConfig")
        private String changeConfig;

        /** changeConfig=true生效，变更配置后的存储空间，单位为G，如果不变更可以不传，取值范围是实例当前的存储空间~32768 */
        @JsonProperty("newStorageSize")
        private Integer newStorageSize;

        /** changeConfig=true生效，变更配置后的规格名称，nCmG格式，如果不变更可以不传 */
        @JsonProperty("newSpecName")
        private String newSpecName;

        /** 迁移时间类型，0-立即切换，1-在可维护时间段进行切换，2-用户指定时间段生效 */
        @JsonProperty("migrationActionType")
        private String migrationActionType;

        /**
         * 用户指定的迁移时间，时间格式yyyy-MM-dd
         * HH:mm:ss，当migrationActionType=2时，该参数不能为空；如果activeCreate小于当前时间，会立即切换
         */
        @JsonProperty("activeCreate")
        private String activeCreate;

        /** 表示分布AZ的节点类型，master表示主节点，slave表示备节点 */
        @JsonProperty("hostType")
        private String hostType;

        /** 资源池可用区Id */
        @JsonProperty("availabilityZoneId")
        private String availabilityZoneId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getChangeConfig() {
            return this.changeConfig;
        }

        public void setChangeConfig(String changeConfig) {
            this.changeConfig = changeConfig;
        }

        public Integer getNewStorageSize() {
            return this.newStorageSize;
        }

        public void setNewStorageSize(Integer newStorageSize) {
            this.newStorageSize = newStorageSize;
        }

        public String getNewSpecName() {
            return this.newSpecName;
        }

        public void setNewSpecName(String newSpecName) {
            this.newSpecName = newSpecName;
        }

        public String getMigrationActionType() {
            return this.migrationActionType;
        }

        public void setMigrationActionType(String migrationActionType) {
            this.migrationActionType = migrationActionType;
        }

        public String getActiveCreate() {
            return this.activeCreate;
        }

        public void setActiveCreate(String activeCreate) {
            this.activeCreate = activeCreate;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }
    }

    public static class AzMigrationResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
