package cn.ctyun.apis.deadlock;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 获取死锁信息列表 */
public class Rds2DeadlockDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2DeadlockDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/deadlock/detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DeadlockDetailResponse send(Credential credential, DeadlockDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        if (request.resId != null) {
            ctReq.addParam("resId", String.valueOf(request.resId));
            request.resId = null;
        }
        if (request.ts != null) {
            ctReq.addParam("ts", request.ts);
            request.ts = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DeadlockDetailResponse.class);
    }

    public static class DeadlockDetailRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 节点ID */
        @JsonProperty("resId")
        private Integer resId;

        /** 死锁出现的时间戳 */
        @JsonProperty("ts")
        private String ts;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getTs() {
            return this.ts;
        }

        public void setTs(String ts) {
            this.ts = ts;
        }
    }

    public static class DeadlockDetailResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DeadlockDetailReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DeadlockDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DeadlockDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DeadlockDetailReturnObjResponse {
        /** 返回对象 */
        @JsonProperty("data")
        private List<DeadlockDetailReturnObjDataResponse> data;

        public List<DeadlockDetailReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<DeadlockDetailReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class DeadlockDetailReturnObjDataResponse {
        /** 引起死锁的模式 */
        @JsonProperty("lockMode")
        private String lockMode;

        /** 应用端ip */
        @JsonProperty("ip")
        private String ip;

        /** 事务sql语句 */
        @JsonProperty("query")
        private String query;

        /** 事务所属线程ID */
        @JsonProperty("thread")
        private Integer thread;

        /** 当前事务持有锁的类型 */
        @JsonProperty("lockType")
        private String lockType;

        /** 节点ID */
        @JsonProperty("resId")
        private Integer resId;

        /** 事务在等待锁(w)或持有锁(h) */
        @JsonProperty("waitHold")
        private String waitHold;

        /** 应用hostname */
        @JsonProperty("hostname")
        private String hostname;

        /** 数据库端口 */
        @JsonProperty("port")
        private Integer port;

        /** 死锁分析时间 */
        @JsonProperty("createTime")
        private String createTime;

        /** 服务端ip */
        @JsonProperty("host")
        private String host;

        /** 事务执行时间 */
        @JsonProperty("txnTime")
        private Integer txnTime;

        /** 产品实例ID */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        /** 1:该事务被回滚 0:未回滚 */
        @JsonProperty("victim")
        private Integer victim;

        /** 记录ID */
        @JsonProperty("id")
        private Integer id;

        /** 使用的索引信息 */
        @JsonProperty("idx")
        private String idx;

        /** 应用连接用户 */
        @JsonProperty("user")
        private String user;

        /** 事务发生的库 */
        @JsonProperty("db")
        private String db;

        /** 死锁发生的时间戳 */
        @JsonProperty("ts")
        private String ts;

        /** 事务ID */
        @JsonProperty("txnId")
        private Integer txnId;

        /** 表名 */
        @JsonProperty("tbl")
        private String tbl;

        public String getLockMode() {
            return this.lockMode;
        }

        public void setLockMode(String lockMode) {
            this.lockMode = lockMode;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Integer getThread() {
            return this.thread;
        }

        public void setThread(Integer thread) {
            this.thread = thread;
        }

        public String getLockType() {
            return this.lockType;
        }

        public void setLockType(String lockType) {
            this.lockType = lockType;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public String getWaitHold() {
            return this.waitHold;
        }

        public void setWaitHold(String waitHold) {
            this.waitHold = waitHold;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getTxnTime() {
            return this.txnTime;
        }

        public void setTxnTime(Integer txnTime) {
            this.txnTime = txnTime;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getVictim() {
            return this.victim;
        }

        public void setVictim(Integer victim) {
            this.victim = victim;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getIdx() {
            return this.idx;
        }

        public void setIdx(String idx) {
            this.idx = idx;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getTs() {
            return this.ts;
        }

        public void setTs(String ts) {
            this.ts = ts;
        }

        public Integer getTxnId() {
            return this.txnId;
        }

        public void setTxnId(Integer txnId) {
            this.txnId = txnId;
        }

        public String getTbl() {
            return this.tbl;
        }

        public void setTbl(String tbl) {
            this.tbl = tbl;
        }
    }
}
