package cn.ctyun.apis.database;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询RDS实例支持的字符集 */
public class Rds2ShowCharacterSetV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2ShowCharacterSetV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/database/show-character-set",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowCharacterSetV4Response send(Credential credential, ShowCharacterSetV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowCharacterSetV4Response.class);
    }

    public static class ShowCharacterSetV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class ShowCharacterSetV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private ShowCharacterSetV4ReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ShowCharacterSetV4ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowCharacterSetV4ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }


    public static class ShowCharacterSetV4ReturnObjResponse {
        @JsonProperty("data")
        private List<ShowCharacterSetV4DataResponse> data;

        public List<ShowCharacterSetV4DataResponse> getData() {
            return data;
        }

        public void setData(List<ShowCharacterSetV4DataResponse> data) {
            this.data = data;
        }
    }


    public static class ShowCharacterSetV4DataResponse {
        /** 字符集名称 */
        @JsonProperty("charset")
        private String charset;

        /** 默认排序规则 */
        @JsonProperty("description")
        private String description;

        /** 最大占用字节数 */
        @JsonProperty("maxlen")
        private Integer maxlen;

        /** 默认校对规则 */
        @JsonProperty("defaultCollation")
        private String defaultCollation;

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getMaxlen() {
            return this.maxlen;
        }

        public void setMaxlen(Integer maxlen) {
            this.maxlen = maxlen;
        }

        public String getDefaultCollation() {
            return this.defaultCollation;
        }

        public void setDefaultCollation(String defaultCollation) {
            this.defaultCollation = defaultCollation;
        }
    }
}
