package cn.ctyun.apis.database;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询RDS实例下的数据库信息。 */
public class Rds2QuerySchemaByProdIdV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2QuerySchemaByProdIdV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/database/schemas",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QuerySchemaByProdIdV4Response send(
            Credential credential, QuerySchemaByProdIdV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QuerySchemaByProdIdV4Response.class);
    }

    public static class QuerySchemaByProdIdV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class QuerySchemaByProdIdV4Response {
        /**
         * 返回码<br>
         * 取值范围：0 成功
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<QuerySchemaByProdIdV4ReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<QuerySchemaByProdIdV4ReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<QuerySchemaByProdIdV4ReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QuerySchemaByProdIdV4ReturnObjResponse {
        /** 用户信息列表 */
        @JsonProperty("userVOList")
        private List<QuerySchemaByProdIdV4ReturnObjUserVOListResponse> userVOList;

        /** 数据库名称 */
        @JsonProperty("grantSchema")
        private String grantSchema;

        @JsonProperty("charsetName")
        private String charsetName;

        @JsonProperty("collationName")
        private String collationName;

        @JsonProperty("remark")
        private String remark;

        public List<QuerySchemaByProdIdV4ReturnObjUserVOListResponse> getUserVOList() {
            return this.userVOList;
        }

        public void setUserVOList(
                List<QuerySchemaByProdIdV4ReturnObjUserVOListResponse> userVOList) {
            this.userVOList = userVOList;
        }

        public String getGrantSchema() {
            return this.grantSchema;
        }

        public void setGrantSchema(String grantSchema) {
            this.grantSchema = grantSchema;
        }

        public String getCharsetName() {
            return charsetName;
        }

        public void setCharsetName(String charsetName) {
            this.charsetName = charsetName;
        }

        public String getCollationName() {
            return collationName;
        }

        public void setCollationName(String collationName) {
            this.collationName = collationName;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }

    public static class QuerySchemaByProdIdV4ReturnObjUserVOListResponse {
        /** 数据库用户名 */
        @JsonProperty("accountName")
        private String accountName;

        /** 用户读写权限 */
        @JsonProperty("readOnly")
        private Boolean readOnly;

        /** 查询权限 */
        @JsonProperty("selectPriv")
        private String selectPriv;

        /** 写入权限 */
        @JsonProperty("insertPriv")
        private String insertPriv;

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public String getSelectPriv() {
            return this.selectPriv;
        }

        public void setSelectPriv(String selectPriv) {
            this.selectPriv = selectPriv;
        }

        public String getInsertPriv() {
            return this.insertPriv;
        }

        public void setInsertPriv(String insertPriv) {
            this.insertPriv = insertPriv;
        }
    }
}
