package cn.ctyun.apis.database;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 获取指定RDS实例下节点的binlog信息。如果未开启binlog开关，则返回空的查询结果。 */
public class Rds2DescribeBinlogFilesV4Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2DescribeBinlogFilesV4Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v1/open-api/database/describe-binlog-files",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeBinlogFilesV4Response send(
            Credential credential, DescribeBinlogFilesV4Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeBinlogFilesV4Response.class);
    }

    public static class DescribeBinlogFilesV4Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class DescribeBinlogFilesV4Response {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<DescribeBinlogFilesV4ReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<DescribeBinlogFilesV4ReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<DescribeBinlogFilesV4ReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeBinlogFilesV4ReturnObjResponse {
        /** 资源ID */
        @JsonProperty("Res_id")
        private Integer res_id;

        /** Binlog文件名 */
        @JsonProperty("Log_name")
        private String log_name;

        /** Binlog文件大小 */
        @JsonProperty("File_size")
        private Integer file_size;

        /** 端口 */
        @JsonProperty("Port")
        private String port;

        /** 实例角色 */
        @JsonProperty("Role")
        private String role;

        /** 地址 */
        @JsonProperty("Host")
        private String host;

        public Integer getRes_id() {
            return this.res_id;
        }

        public void setRes_id(Integer res_id) {
            this.res_id = res_id;
        }

        public String getLog_name() {
            return this.log_name;
        }

        public void setLog_name(String log_name) {
            this.log_name = log_name;
        }

        public Integer getFile_size() {
            return this.file_size;
        }

        public void setFile_size(Integer file_size) {
            this.file_size = file_size;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }
    }
}
