package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 扩容下单购买的自研数据库实例，提供OpenApi能力 */
public class Rds2UpgradeV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2UpgradeV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/teledb-acceptor/v2/openapi/accept-order-info/upgrade",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpgradeV2Response send(Credential credential, UpgradeV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpgradeV2Response.class);
    }

    public static class UpgradeV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id */
        @JsonProperty("instId")
        private String instId;

        /** 节点类型，master=主节点，backup=备份节点，当为磁盘扩容&系列升级时，该字段不为空 */
        @JsonProperty("nodeType")
        private String nodeType;

        /** 产品ID，prodId不为空&diskVolume为空&prodPerformanceSpec为空，为产品系列升级 */
        @JsonProperty("prodId")
        private String prodId;

        /** 升级到的磁盘容量，单位G，范围为[100G，32768G]，diskVolume不为空的时候，为磁盘扩容 */
        @JsonProperty("diskVolume")
        private String diskVolume;

        /** 产品规格名，类似"4C8G"这种；prodPerformanceSpec不为空 &diskVolume为空时，为规格扩容 */
        @JsonProperty("prodPerformanceSpec")
        private String prodPerformanceSpec;

        /** 可用区节点相关信息 */
        @JsonProperty("azList")
        private List<UpgradeV2AzListRequest> azList;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getProdId() {
            return this.prodId;
        }

        public void setProdId(String prodId) {
            this.prodId = prodId;
        }

        public String getDiskVolume() {
            return this.diskVolume;
        }

        public void setDiskVolume(String diskVolume) {
            this.diskVolume = diskVolume;
        }

        public String getProdPerformanceSpec() {
            return this.prodPerformanceSpec;
        }

        public void setProdPerformanceSpec(String prodPerformanceSpec) {
            this.prodPerformanceSpec = prodPerformanceSpec;
        }

        public List<UpgradeV2AzListRequest> getAzList() {
            return this.azList;
        }

        public void setAzList(List<UpgradeV2AzListRequest> azList) {
            this.azList = azList;
        }
    }

    public static class UpgradeV2AzListRequest {
        /** 可用区名 */
        @JsonProperty("availabilityZoneName")
        private String availabilityZoneName;

        /** 可用区新增节点数量 */
        @JsonProperty("availabilityZoneCount")
        private String availabilityZoneCount;

        public String getAvailabilityZoneName() {
            return this.availabilityZoneName;
        }

        public void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        public String getAvailabilityZoneCount() {
            return this.availabilityZoneCount;
        }

        public void setAvailabilityZoneCount(String availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
        }
    }

    public static class UpgradeV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    @Data
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private UpgradeV2ReturnObjResponse data;


    }
    public static class UpgradeV2ReturnObjResponse {
        /** 订单id */
        @JsonProperty("newOrderId")
        private String newOrderId;

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }
    }
}
