package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 开通自研数据库实例时，需要选择开通产品的规格，该接口提供支持的产品规格列表查询OpenApi能力 */
public class Rds2TemplateV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2TemplateV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-acceptor/v2/openapi/accept-order-info/template",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public TemplateV2Response send(Credential credential, TemplateV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.prodType != null) {
            ctReq.addParam("prodType", request.prodType);
            request.prodType = null;
        }
        if (request.prodCode != null) {
            ctReq.addParam("prodCode", request.prodCode);
            request.prodCode = null;
        }
        if (request.regionId != null) {
            ctReq.addParam("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.instanceType != null) {
            ctReq.addParam("instanceType", request.instanceType);
            request.instanceType = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(TemplateV2Response.class);
    }

    public static class TemplateV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 产品类型，0=UNKNOWN, 1=RDS, 2=NoSql, 3=TOOL, 4=MemDB */
        @JsonProperty("prodType")
        private String prodType;

        /** 产品编码，取值范围：HBASE/DDS/HBASE/MYSQL/POSTGRESQL/SQLSERVER */
        @JsonProperty("prodCode")
        private String prodCode;

        /** 区域id */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例类型，1=通用型，2=计算增强型，3=内存优化型，4=直通（未用到） */
        @JsonProperty("instanceType")
        private String instanceType;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getProdType() {
            return this.prodType;
        }

        public void setProdType(String prodType) {
            this.prodType = prodType;
        }

        public String getProdCode() {
            return this.prodCode;
        }

        public void setProdCode(String prodCode) {
            this.prodCode = prodCode;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }
    }

    public static class TemplateV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    @Data
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private List<TemplateV2ReturnObjResponse> data;


    }
    public static class TemplateV2ReturnObjResponse {
        /** 产品id */
        @JsonProperty("prodId")
        private Integer prodId;

        /** 产品编码 */
        @JsonProperty("prodCode")
        private String prodCode;

        /** 产品名称 */
        @JsonProperty("prodSpecName")
        private String prodSpecName;

        /** 产品描述 */
        @JsonProperty("prodSpecDesc")
        private String prodSpecDesc;

        /** 实例描述 */
        @JsonProperty("instanceDesc")
        private String instanceDesc;

        /** 产品版本 */
        @JsonProperty("prodVersion")
        private String prodVersion;

        /** 主机规格 */
        @JsonProperty("hostSpec")
        private String hostSpec;

        /** lvs规格 */
        @JsonProperty("lvsSpec")
        private String lvsSpec;

        /** AZ支持的产品规格信息，以及规格代S6/S7 */
        @JsonProperty("instSpecInfoList")
        private List<TemplateV2ReturnObjInstSpecInfoListResponse> instSpecInfoList;

        /** 区域id */
        @JsonProperty("prodHostConfig")
        private TemplateV2ReturnObjProdHostConfigResponse prodHostConfig;

        public Integer getProdId() {
            return this.prodId;
        }

        public void setProdId(Integer prodId) {
            this.prodId = prodId;
        }

        public String getProdCode() {
            return this.prodCode;
        }

        public void setProdCode(String prodCode) {
            this.prodCode = prodCode;
        }

        public String getProdSpecName() {
            return this.prodSpecName;
        }

        public void setProdSpecName(String prodSpecName) {
            this.prodSpecName = prodSpecName;
        }

        public String getProdSpecDesc() {
            return this.prodSpecDesc;
        }

        public void setProdSpecDesc(String prodSpecDesc) {
            this.prodSpecDesc = prodSpecDesc;
        }

        public String getInstanceDesc() {
            return this.instanceDesc;
        }

        public void setInstanceDesc(String instanceDesc) {
            this.instanceDesc = instanceDesc;
        }

        public String getProdVersion() {
            return this.prodVersion;
        }

        public void setProdVersion(String prodVersion) {
            this.prodVersion = prodVersion;
        }

        public String getHostSpec() {
            return this.hostSpec;
        }

        public void setHostSpec(String hostSpec) {
            this.hostSpec = hostSpec;
        }

        public String getLvsSpec() {
            return this.lvsSpec;
        }

        public void setLvsSpec(String lvsSpec) {
            this.lvsSpec = lvsSpec;
        }

        public List<TemplateV2ReturnObjInstSpecInfoListResponse> getInstSpecInfoList() {
            return this.instSpecInfoList;
        }

        public void setInstSpecInfoList(
                List<TemplateV2ReturnObjInstSpecInfoListResponse> instSpecInfoList) {
            this.instSpecInfoList = instSpecInfoList;
        }

        public TemplateV2ReturnObjProdHostConfigResponse getProdHostConfig() {
            return this.prodHostConfig;
        }

        public void setProdHostConfig(TemplateV2ReturnObjProdHostConfigResponse prodHostConfig) {
            this.prodHostConfig = prodHostConfig;
        }
    }

    public static class TemplateV2ReturnObjInstSpecInfoListResponse {
        /** 废弃 */
        @JsonProperty("specId")
        private String specId;

        /** 规格名称 */
        @JsonProperty("prodPerformanceSpec")
        private String prodPerformanceSpec;

        /** 该规格支持的AZ列表 */
        @JsonProperty("azList")
        private List<String> azList;

        /** 主机世代完整名称 */
        @JsonProperty("specName")
        private String specName;

        /** cpu类型 */
        @JsonProperty("cpuType")
        private String cpuType;

        /** 主机世代缩写 */
        @JsonProperty("generation")
        private String generation;

        /** 带宽下限 */
        @JsonProperty("minRate")
        private String minRate;

        /** 带宽上限 */
        @JsonProperty("maxRate")
        private String maxRate;

        public String getSpecId() {
            return this.specId;
        }

        public void setSpecId(String specId) {
            this.specId = specId;
        }

        public String getProdPerformanceSpec() {
            return this.prodPerformanceSpec;
        }

        public void setProdPerformanceSpec(String prodPerformanceSpec) {
            this.prodPerformanceSpec = prodPerformanceSpec;
        }

        public List<String> getAzList() {
            return this.azList;
        }

        public void setAzList(List<String> azList) {
            this.azList = azList;
        }

        public String getSpecName() {
            return this.specName;
        }

        public void setSpecName(String specName) {
            this.specName = specName;
        }

        public String getCpuType() {
            return this.cpuType;
        }

        public void setCpuType(String cpuType) {
            this.cpuType = cpuType;
        }

        public String getGeneration() {
            return this.generation;
        }

        public void setGeneration(String generation) {
            this.generation = generation;
        }

        public String getMinRate() {
            return this.minRate;
        }

        public void setMinRate(String minRate) {
            this.minRate = minRate;
        }

        public String getMaxRate() {
            return this.maxRate;
        }

        public void setMaxRate(String maxRate) {
            this.maxRate = maxRate;
        }
    }

    public static class TemplateV2ReturnObjProdHostConfigResponse {
        /** host实例 */
        @JsonProperty("hostInsts")
        private List<TemplateV2ReturnObjProdHostConfigHostInstsResponse> hostInsts;

        public List<TemplateV2ReturnObjProdHostConfigHostInstsResponse> getHostInsts() {
            return this.hostInsts;
        }

        public void setHostInsts(
                List<TemplateV2ReturnObjProdHostConfigHostInstsResponse> hostInsts) {
            this.hostInsts = hostInsts;
        }
    }

    public static class TemplateV2ReturnObjProdHostConfigHostInstsResponse {
        /** 类型名称 */
        @JsonProperty("hostTypeName")
        private String hostTypeName;

        /** 节点类型，当类型为mysql时，取值范围master（主节点）、readnode（只读节点） */
        @JsonProperty("hostType")
        private String hostType;

        /** 支持的性能指标规格列表 */
        @JsonProperty("prodPerformanceSpeces")
        private List<String> prodPerformanceSpeces;

        /** 节点默认数量 */
        @JsonProperty("hostDefaultNum")
        private Integer hostDefaultNum;

        public String getHostTypeName() {
            return this.hostTypeName;
        }

        public void setHostTypeName(String hostTypeName) {
            this.hostTypeName = hostTypeName;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public List<String> getProdPerformanceSpeces() {
            return this.prodPerformanceSpeces;
        }

        public void setProdPerformanceSpeces(List<String> prodPerformanceSpeces) {
            this.prodPerformanceSpeces = prodPerformanceSpeces;
        }

        public Integer getHostDefaultNum() {
            return this.hostDefaultNum;
        }

        public void setHostDefaultNum(Integer hostDefaultNum) {
            this.hostDefaultNum = hostDefaultNum;
        }
    }
}
