package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 用户查询安全组列表 */
public class Rds2SecurityGroupV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2SecurityGroupV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-dcp/v2/openapi/dcp-order-info/securityGroup",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public SecurityGroupV2Response send(Credential credential, SecurityGroupV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.regionId != null) {
            ctReq.addParam("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.instId != null) {
            ctReq.addParam("instId", request.instId);
            request.instId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SecurityGroupV2Response.class);
    }

    public static class SecurityGroupV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 资源池id */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("instId")
        private String instId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }
    }

    public static class SecurityGroupV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    @Data
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private List<SecurityGroupV2ReturnObjResponse> data;


    }
    public static class SecurityGroupV2ReturnObjResponse {
        /** 安全组名称 */
        @JsonProperty("securityGroupName")
        private String securityGroupName;

        /** 安全组id */
        @JsonProperty("id")
        private String id;

        /** 相关云主机 */
        @JsonProperty("vmNum")
        private String vmNum;

        /** 企业项目 */
        @JsonProperty("origin")
        private String origin;

        /** vpc名称 */
        @JsonProperty("vpcName")
        private String vpcName;

        /** 创建时间 */
        @JsonProperty("creationTime")
        private String creationTime;

        /** 资源池id */
        @JsonProperty("regionId")
        private String regionId;

        /** 安全组描述信息 */
        @JsonProperty("description")
        private String description;

        /** 废弃 */
        @JsonProperty("projectIdEcs")
        private String projectIdEcs;

        /** 废弃 */
        @JsonProperty("dataId")
        private String dataId;

        /** 废弃 */
        @JsonProperty("talkOrder")
        private Boolean talkOrder;

        /** 虚拟私有云网ID */
        @JsonProperty("vpcId")
        private String vpcId;

        /** 安全组规则信息 */
        @JsonProperty("securityGroupRules")
        private List<SecurityGroupV2ReturnObjSecurityGroupRulesResponse> securityGroupRules;

        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getVmNum() {
            return this.vmNum;
        }

        public void setVmNum(String vmNum) {
            this.vmNum = vmNum;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public String getCreationTime() {
            return this.creationTime;
        }

        public void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getProjectIdEcs() {
            return this.projectIdEcs;
        }

        public void setProjectIdEcs(String projectIdEcs) {
            this.projectIdEcs = projectIdEcs;
        }

        public String getDataId() {
            return this.dataId;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public Boolean getTalkOrder() {
            return this.talkOrder;
        }

        public void setTalkOrder(Boolean talkOrder) {
            this.talkOrder = talkOrder;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public List<SecurityGroupV2ReturnObjSecurityGroupRulesResponse> getSecurityGroupRules() {
            return this.securityGroupRules;
        }

        public void setSecurityGroupRules(
                List<SecurityGroupV2ReturnObjSecurityGroupRulesResponse> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
        }
    }

    public static class SecurityGroupV2ReturnObjSecurityGroupRulesResponse {
        /** 出方向-egress、入方向-ingress */
        @JsonProperty("direction")
        private String direction;

        /** 优先级:0~100 */
        @JsonProperty("priority")
        private Integer priority;

        /** IP类型:IPv4、IPv6 */
        @JsonProperty("etherType")
        private String etherType;

        /** 协议: ANY、TCP、UDP、ICMP(v4) */
        @JsonProperty("protocol")
        private String protocol;

        /** 协议: ANY、TCP、UDP、ICMP(v4) */
        @JsonProperty("range")
        private String range;

        /** 远端地址:0.0.0.0/0 */
        @JsonProperty("destCidrIp")
        private String destCidrIp;

        /** 安全组规则描述信息 */
        @JsonProperty("description")
        private String description;

        /** 唯一标识ID */
        @JsonProperty("id")
        private String id;

        /** 安全组ID */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** 废弃 */
        @JsonProperty("dataId")
        private String dataId;

        /** 废弃 */
        @JsonProperty("action")
        private String action;

        /** 企业项目 */
        @JsonProperty("origin")
        private String origin;

        /** 创建时间，UTC时间 */
        @JsonProperty("createTime")
        private String createTime;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getEtherType() {
            return this.etherType;
        }

        public void setEtherType(String etherType) {
            this.etherType = etherType;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getDataId() {
            return this.dataId;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }
    }
}
