package cn.ctyun.apis.common;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 开通自研数据库实例时，需要选择开通产品的区域，该接口提供产品支持的区域列表查询OpenApi能力 */
public class Rds2RegionInfoV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2RegionInfoV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/teledb-acceptor/v2/openapi/accept-order-info/regionInfo",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RegionInfoV2Response send(Credential credential, RegionInfoV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.prodEngineName != null) {
            ctReq.addParam("prodEngineName", request.prodEngineName);
            request.prodEngineName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RegionInfoV2Response.class);
    }

    public static class RegionInfoV2Request {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 产品名称：MYSQL */
        @JsonProperty("prodEngineName")
        private String prodEngineName;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getProdEngineName() {
            return this.prodEngineName;
        }

        public void setProdEngineName(String prodEngineName) {
            this.prodEngineName = prodEngineName;
        }
    }

    public static class RegionInfoV2Response {
        /** 接口状态码，参考下方状态码 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        /** 描述信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DataResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DataResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DataResponse returnObj) {
            this.returnObj = returnObj;
        }
    }
    @Data
    public static class DataResponse {
        /**
         * 状态码
         */
        @JsonProperty("data")
        private List<RegionInfoV2ReturnObjResponse> data;


    }

    public static class RegionInfoV2ReturnObjResponse {
        /** 区域id */
        @JsonProperty("regionId")
        private String regionId;

        /** 区域范围 */
        @JsonProperty("regionRange")
        private String regionRange;

        /** 地区 */
        @JsonProperty("regionParent")
        private String regionParent;

        /** 返回编码 */
        @JsonProperty("resPoolCode")
        private String resPoolCode;

        /** 资源池类型 300001-自研池 300002-合营池 */
        @JsonProperty("endpoint")
        private String endpoint;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRegionRange() {
            return this.regionRange;
        }

        public void setRegionRange(String regionRange) {
            this.regionRange = regionRange;
        }

        public String getRegionParent() {
            return this.regionParent;
        }

        public void setRegionParent(String regionParent) {
            this.regionParent = regionParent;
        }

        public String getResPoolCode() {
            return this.resPoolCode;
        }

        public void setResPoolCode(String resPoolCode) {
            this.resPoolCode = resPoolCode;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }
    }
}
